/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationMemberDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.PropertyTypeFactory;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationMemberDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;

public class DataModelerServiceHelper {
    public static DataModelerServiceHelper getInstance() {
        return new DataModelerServiceHelper();
    }

    public DataModel to2Domain(DataModelTO dataModelTO) {
        DataModel dataModel = ModelFactoryImpl.getInstance().newModel();
        List dataObjects = dataModelTO.getDataObjects();
        if (dataObjects != null) {
            for (DataObjectTO dataObjectTO : dataObjects) {
                DataObject dataObject = dataModel.addDataObject(dataObjectTO.getPackageName(), dataObjectTO.getName());
                this.to2Domain(dataObjectTO, dataObject);
            }
        }
        return dataModel;
    }

    public DataModelTO domain2To(DataModel dataModel, Integer initialStatus, boolean calculateFingerprints) throws Exception {
        DataModelTO dataModelTO = new DataModelTO();
        ArrayList dataObjects = new ArrayList();
        ArrayList externalDataObjects = new ArrayList();
        ArrayList<String> externalClasses = new ArrayList<String>();
        dataObjects.addAll(dataModel.getDataObjects());
        externalDataObjects.addAll(dataModel.getDataObjects(ObjectSource.DEPENDENCY));
        if (dataObjects != null) {
            for (DataObject dataObject : dataObjects) {
                DataObjectTO dataObjectTO = new DataObjectTO(dataObject.getName(), dataObject.getPackageName(), dataObject.getSuperClassName());
                if (initialStatus != null) {
                    dataObjectTO.setStatus(initialStatus.intValue());
                }
                this.domain2To(dataObject, dataObjectTO);
                dataModelTO.getDataObjects().add(dataObjectTO);
                if (!calculateFingerprints) continue;
                dataObjectTO.setFingerPrint(this.calculateFingerPrint(dataObjectTO.getStringId()));
            }
        }
        for (DataObject externalDataObject : externalDataObjects) {
            if (externalClasses.contains(externalDataObject.getClassName())) continue;
            externalClasses.add(externalDataObject.getClassName());
        }
        dataModelTO.setExternalClasses(externalClasses);
        return dataModelTO;
    }

    public void domain2To(DataObject dataObject, DataObjectTO dataObjectTO) {
        dataObjectTO.setName(dataObject.getName());
        dataObjectTO.setOriginalClassName(dataObject.getClassName());
        dataObjectTO.setSuperClassName(dataObject.getSuperClassName());
        ArrayList properties = new ArrayList();
        properties.addAll(dataObject.getProperties().values());
        ArrayList<ObjectPropertyTO> propertiesTO = new ArrayList<ObjectPropertyTO>();
        PropertyTypeFactory typeFactory = PropertyTypeFactoryImpl.getInstance();
        for (Annotation annotation : dataObject.getAnnotations()) {
            AnnotationTO annotationTO = this.domain2To(annotation);
            if (annotationTO == null) continue;
            dataObjectTO.addAnnotation(annotationTO);
        }
        for (ObjectProperty property : properties) {
            ObjectPropertyTO propertyTO = new ObjectPropertyTO(property.getName(), property.getClassName(), property.isMultiple(), typeFactory.isBasePropertyType(property.getClassName()), property.getBag());
            propertiesTO.add(propertyTO);
            for (Annotation annotation : property.getAnnotations()) {
                AnnotationTO annotationTO = this.domain2To(annotation);
                if (annotationTO == null) continue;
                propertyTO.addAnnotation(annotationTO);
            }
        }
        dataObjectTO.setProperties(propertiesTO);
    }

    public void to2Domain(DataObjectTO dataObjectTO, DataObject dataObject) {
        dataObject.setName(dataObjectTO.getName());
        List properties = dataObjectTO.getProperties();
        dataObject.setSuperClassName(dataObjectTO.getSuperClassName());
        for (AnnotationTO annotationTO : dataObjectTO.getAnnotations()) {
            Annotation annotation = this.to2Domain(annotationTO);
            if (annotation == null) continue;
            dataObject.addAnnotation(annotation);
        }
        if (properties != null) {
            for (ObjectPropertyTO propertyTO : properties) {
                ObjectProperty property = dataObject.addProperty(propertyTO.getName(), propertyTO.getClassName(), propertyTO.isMultiple(), propertyTO.getBag());
                for (AnnotationTO annotationTO : propertyTO.getAnnotations()) {
                    Annotation annotation = this.to2Domain(annotationTO);
                    if (annotation == null) continue;
                    property.addAnnotation(annotation);
                }
            }
        }
    }

    public Annotation to2Domain(AnnotationTO annotationTO) {
        AnnotationDefinition annotationDefinition = this.to2Domain(annotationTO.getAnnotationDefinition());
        AnnotationImpl annotation = new AnnotationImpl(annotationDefinition);
        for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
            Object memberValue = annotationTO.getValue(memberDefinition.getName());
            if (memberValue == null) continue;
            annotation.setValue(memberDefinition.getName(), memberValue);
        }
        return annotation;
    }

    public AnnotationDefinition to2Domain(AnnotationDefinitionTO annotationDefinitionTO) {
        AnnotationDefinitionImpl annotationDefinition = new AnnotationDefinitionImpl(annotationDefinitionTO.getName(), annotationDefinitionTO.getClassName(), annotationDefinitionTO.getShortDescription(), annotationDefinitionTO.getDescription(), annotationDefinitionTO.isObjectAnnotation(), annotationDefinitionTO.isPropertyAnnotation());
        for (AnnotationMemberDefinitionTO memberDefinitionTO : annotationDefinitionTO.getAnnotationMembers()) {
            AnnotationMemberDefinitionImpl memberDefinition = new AnnotationMemberDefinitionImpl(memberDefinitionTO.getName(), memberDefinitionTO.getClassName(), memberDefinitionTO.isEnum(), memberDefinitionTO.getDefaultValue(), memberDefinitionTO.getShortDescription(), memberDefinitionTO.getDescription());
            annotationDefinition.addMember((AnnotationMemberDefinition)memberDefinition);
        }
        return annotationDefinition;
    }

    public AnnotationTO domain2To(Annotation annotation) {
        AnnotationDefinitionTO annotationDefinitionTO = this.domain2To(annotation.getAnnotationDefinition());
        AnnotationTO annotationTO = new AnnotationTO(annotationDefinitionTO);
        for (AnnotationMemberDefinitionTO memberDefinitionTO : annotationDefinitionTO.getAnnotationMembers()) {
            Object memberValue = annotation.getValue(memberDefinitionTO.getName());
            if (memberValue == null) continue;
            annotationTO.setValue(memberDefinitionTO.getName(), memberValue);
        }
        return annotationTO;
    }

    public AnnotationDefinitionTO domain2To(AnnotationDefinition annotationDefinition) {
        AnnotationDefinitionTO annotationDefinitionTO = new AnnotationDefinitionTO(annotationDefinition.getName(), annotationDefinition.getClassName(), annotationDefinition.getShortDescription(), annotationDefinition.getDescription(), annotationDefinition.isObjectAnnotation(), annotationDefinition.isPropertyAnnotation());
        for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
            AnnotationMemberDefinitionTO memberDefinitionTO = new AnnotationMemberDefinitionTO(memberDefinition.getName(), memberDefinition.getClassName(), memberDefinition.isPrimitiveType(), memberDefinition.isEnum(), memberDefinition.defaultValue(), memberDefinition.getShortDescription(), memberDefinition.getDescription());
            annotationDefinitionTO.addMember(memberDefinitionTO);
        }
        return annotationDefinitionTO;
    }

    public String calculateFingerPrint(String str) {
        return Base64.encodeBase64String((byte[])DigestUtils.sha((String)str));
    }

    public String calculateFingerPrint(Object obj) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.close();
        byte[] fingerPrint = DigestUtils.sha((byte[])byteArrayOutputStream.toByteArray());
        return Base64.encodeBase64String((byte[])fingerPrint);
    }

    public Map<String, String> claculateFingerPrints(DataModelTO dataModelTO) {
        HashMap<String, String> fingerPrints = new HashMap<String, String>();
        for (DataObjectTO dataObjectTO : dataModelTO.getDataObjects()) {
            fingerPrints.put(dataObjectTO.getClassName(), this.calculateFingerPrint(dataObjectTO.getStringId()));
        }
        return fingerPrints;
    }
}

