/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.drools.repository.ClassUtil;
import org.drools.repository.JCRRepositoryConfigurator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesRepositoryConfigurator {
    private static final Logger log = LoggerFactory.getLogger(RulesRepositoryConfigurator.class);
    public static final String PROPERTIES_FILE = "/drools_repository.properties";
    public static final String CONFIGURATOR_CLASS = "org.drools.repository.configurator";
    private static JCRRepositoryConfigurator jcrRepositoryConfigurator = null;
    private static Repository jcrRepository = null;
    private static RulesRepositoryConfigurator rulesRepositoryConfigurator = null;

    private RulesRepositoryConfigurator() {
    }

    public Repository getJCRRepository() {
        return jcrRepository;
    }

    public static synchronized RulesRepositoryConfigurator getInstance(Properties properties) {
        if (rulesRepositoryConfigurator == null) {
            String configuratorClazz;
            log.info("Creating an instance of the RulesRepositoryConfigurator.");
            rulesRepositoryConfigurator = new RulesRepositoryConfigurator();
            if (properties == null) {
                properties = new Properties();
                InputStream propStream = ClassUtil.getResourceAsStream(PROPERTIES_FILE, rulesRepositoryConfigurator.getClass());
                if (propStream != null) {
                    try {
                        properties.load(propStream);
                    }
                    catch (IOException ioe) {
                        throw new RulesRepositoryException(ioe);
                    }
                    finally {
                        try {
                            propStream.close();
                        }
                        catch (IOException ioe) {
                            throw new RulesRepositoryException(ioe);
                        }
                    }
                }
                throw new RulesRepositoryException("Cannot load properties from /drools_repository.properties");
            }
            if ((configuratorClazz = properties.getProperty(CONFIGURATOR_CLASS)) == null) {
                throw new RulesRepositoryException("User must define a 'org.drools.repository.configurator' property.");
            }
            try {
                Class clazz = ClassUtil.forName(configuratorClazz, rulesRepositoryConfigurator.getClass());
                jcrRepositoryConfigurator = (JCRRepositoryConfigurator)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RulesRepositoryException(e);
            }
            catch (InstantiationException e) {
                throw new RulesRepositoryException(e);
            }
            catch (IllegalAccessException e) {
                throw new RulesRepositoryException(e);
            }
            try {
                jcrRepository = jcrRepositoryConfigurator.getJCRRepository(properties);
            }
            catch (RepositoryException e) {
                throw new RulesRepositoryException(e);
            }
        }
        return rulesRepositoryConfigurator;
    }

    public Session login(String userName, String password) throws RepositoryException {
        return jcrRepositoryConfigurator.login(userName, password);
    }

    public Session login(String userName) throws RepositoryException {
        return jcrRepositoryConfigurator.login(userName);
    }

    public void setupRepository(Session session) throws RepositoryException {
        log.info("Setting up the repository, registering node types etc.");
        try {
            Node repositoryNode;
            Node packageAreaNode;
            Node root = session.getRootNode();
            Workspace ws = session.getWorkspace();
            boolean registered = RulesRepositoryAdministrator.isNamespaceRegistered(session);
            if (!registered) {
                ws.getNamespaceRegistry().registerNamespace("drools", "http://www.jboss.org/drools-repository/1.0");
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/configuration_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/tag_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/state_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/versionable_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/versionable_asset_folder_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/rule_node_type.cnd", session, ws);
                jcrRepositoryConfigurator.registerNodeTypesFromCndFile("/node_type_definitions/rulepackage_node_type.cnd", session, ws);
            }
            if (!(packageAreaNode = RulesRepository.addNodeIfNew(repositoryNode = RulesRepository.addNodeIfNew(root, "drools:repository", "nt:folder"), "drools:package_area", "nt:folder")).hasNode("globalArea")) {
                Node globalAreaNode = RulesRepository.addNodeIfNew(packageAreaNode, "globalArea", "drools:packageNodeType");
                globalAreaNode.addNode("assets", "drools:versionableAssetFolder");
                globalAreaNode.setProperty("drools:title", "globalArea");
                globalAreaNode.setProperty("drools:description", "the global area that holds sharable assets");
                globalAreaNode.setProperty("drools:format", "package");
                globalAreaNode.setProperty("drools:creator", session.getUserID());
                Calendar lastModified = Calendar.getInstance();
                globalAreaNode.setProperty("drools:lastModified", lastModified);
            }
            RulesRepository.addNodeIfNew(repositoryNode, "drools:packagesnapshot_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:tag_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:state_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode.getNode("drools:state_area"), "Draft", "drools:stateNodeType");
            RulesRepository.addNodeIfNew(repositoryNode, "drools:schema_area", "nt:folder");
            RulesRepository.addNodeIfNew(repositoryNode.getNode("drools:schema_area"), "drools:workspace_area", "nt:folder");
            session.save();
        }
        catch (RuntimeException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void shutdown() {
        jcrRepositoryConfigurator.shutdown();
        log.info("SHUTDOWN RULES CONFIG");
        rulesRepositoryConfigurator = null;
    }
}

