/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;

public class AbstractAnnotationDefinition
implements AnnotationDefinition {
    protected String name;
    protected String shortDescription;
    protected String description;
    protected String className;
    protected List<AnnotationMemberDefinition> annotationMembers = new ArrayList<AnnotationMemberDefinition>();
    protected Map<String, AnnotationMemberDefinition> annotationMemberMap = new HashMap<String, AnnotationMemberDefinition>();
    protected boolean objectAnnotation = false;
    protected boolean propertyAnnotation = false;

    protected AbstractAnnotationDefinition(String name, String className, String shortDescription, String description, boolean objectAnnotation, boolean propertyAnnotation) {
        this.name = name;
        this.className = className;
        this.shortDescription = shortDescription;
        this.description = description;
        this.objectAnnotation = objectAnnotation;
        this.propertyAnnotation = propertyAnnotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<AnnotationMemberDefinition> getAnnotationMembers() {
        return this.annotationMembers;
    }

    public void addMember(AnnotationMemberDefinition annotationMember) {
        this.annotationMembers.add(annotationMember);
        this.annotationMemberMap.put(annotationMember.getName(), annotationMember);
    }

    @Override
    public boolean isMarker() {
        return this.annotationMembers == null || this.annotationMembers.size() == 0;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isObjectAnnotation() {
        return this.objectAnnotation;
    }

    @Override
    public boolean isPropertyAnnotation() {
        return this.propertyAnnotation;
    }

    @Override
    public boolean hasMember(String name) {
        return this.annotationMemberMap.containsKey(name);
    }
}

