/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;

public class DataModelImpl
implements DataModel {
    Map<String, DataObject> dataObjects = new HashMap<String, DataObject>();
    Map<String, DataObject> dependencyDataObjects = new HashMap<String, DataObject>();

    @Override
    public Set<DataObject> getDataObjects() {
        return this.getDataObjects(ObjectSource.INTERNAL);
    }

    @Override
    public Set<DataObject> getDataObjects(ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.getDataObjects(this.dataObjects);
            }
            case DEPENDENCY: {
                return this.getDataObjects(this.dependencyDataObjects);
            }
        }
        return null;
    }

    @Override
    public DataObject getDataObject(String className) {
        return this.getDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject getDataObject(String className, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.dataObjects.get(className);
            }
            case DEPENDENCY: {
                return this.dependencyDataObjects.get(className);
            }
        }
        return null;
    }

    @Override
    public DataObject removeDataObject(String className) {
        return this.removeDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject removeDataObject(String className, ObjectSource source) {
        switch (source) {
            case INTERNAL: {
                return this.dataObjects.remove(className);
            }
            case DEPENDENCY: {
                return this.dependencyDataObjects.remove(className);
            }
        }
        return null;
    }

    @Override
    public DataObject addDataObject(String packageName, String name) {
        return this.addDataObject(packageName, name, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, int modifiers) {
        return this.addDataObject(packageName, name, ObjectSource.INTERNAL, modifiers);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, ObjectSource source) {
        return this.addDataObject(packageName, name, source, 1);
    }

    @Override
    public DataObject addDataObject(String packageName, String name, ObjectSource source, int modifiers) {
        switch (source) {
            case INTERNAL: {
                return this.addDataObject(packageName, name, this.dataObjects, modifiers);
            }
            case DEPENDENCY: {
                return this.addDataObject(packageName, name, this.dependencyDataObjects, modifiers);
            }
        }
        return null;
    }

    @Override
    public DataObject addDataObject(String className, ObjectSource source, int modifiers) {
        String name = NamingUtils.extractClassName(className);
        String packageName = NamingUtils.extractPackageName(className);
        return this.addDataObject(packageName, name, source, modifiers);
    }

    @Override
    public DataObject addDataObject(String className) {
        return this.addDataObject(className, ObjectSource.INTERNAL);
    }

    @Override
    public DataObject addDataObject(String className, ObjectSource source) {
        return this.addDataObject(className, source, 1);
    }

    private Set<DataObject> getDataObjects(Map<String, DataObject> objectsMap) {
        HashSet<DataObject> set = new HashSet<DataObject>();
        set.addAll(objectsMap.values());
        return set;
    }

    private DataObject addDataObject(String packageName, String name, Map<String, DataObject> objectsMap, int modifiers) {
        DataObjectImpl dataObject = new DataObjectImpl(packageName, name, modifiers);
        objectsMap.put(dataObject.getClassName(), dataObject);
        return dataObject;
    }
}

