/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;

public class DataObjectImpl
extends AbstractHasAnnotations
implements DataObject {
    private String name;
    private String packageName;
    private String superClassName;
    private List<String> imports = new ArrayList<String>();
    private Map<String, ObjectProperty> properties = new HashMap<String, ObjectProperty>();
    int modifiers = 0;

    public DataObjectImpl(String packageName, String name, int modifiers) {
        this.setName(name);
        this.packageName = packageName;
        this.modifiers = modifiers;
    }

    public DataObjectImpl(String packageName, String name) {
        this(packageName, name, 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getClassName() {
        return (this.packageName != null && !"".equals(this.packageName) ? this.packageName + "." : "") + this.getName();
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    @Override
    public Map<String, ObjectProperty> getProperties() {
        return this.properties;
    }

    @Override
    public ObjectProperty addProperty(String name, String className) {
        return this.addProperty(name, className, false);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, int modifiers) {
        return this.addProperty(name, className, false, modifiers);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(name, className, multiple);
        this.properties.put(name, property);
        return property;
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, int modifiers) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(name, className, multiple, modifiers);
        this.properties.put(name, property);
        return property;
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, String bag) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(name, className, multiple, bag);
        this.properties.put(name, property);
        return property;
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, String bag, int modifiers) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(name, className, multiple, bag, modifiers);
        this.properties.put(name, property);
        return property;
    }

    @Override
    public ObjectProperty removeProperty(String name) {
        return this.properties.remove(name);
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }
}

