/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.HashMap;
import java.util.List;
import org.jboss.forge.roaster.model.ValuePair;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.kie.api.definition.type.Description;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Label;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;

public class DefaultJavaRoasterModelAnnotationDriver
implements AnnotationDriver {
    @Override
    public Annotation buildAnnotation(AnnotationDefinition annotationDefinition, Object annotationToken) throws ModelDriverException {
        AnnotationSource javaAnnotationToken = (AnnotationSource)annotationToken;
        AnnotationImpl annotation = new AnnotationImpl(annotationDefinition);
        if (annotationDefinition.isMarker()) {
            return annotation;
        }
        if (javaAnnotationToken.getValues() != null) {
            List values = javaAnnotationToken.getValues();
            HashMap<String, String> valuePairValues = new HashMap<String, String>();
            for (ValuePair valuePair : values) {
                valuePairValues.put(valuePair.getName(), valuePair.getStringValue());
            }
            if (valuePairValues.size() > 0) {
                for (AnnotationMemberDefinition annotationMember : annotationDefinition.getAnnotationMembers()) {
                    String value = (String)valuePairValues.get(annotationMember.getName());
                    if (value == null) continue;
                    annotation.setValue(annotationMember.getName(), this.parseParamValue(annotationDefinition, annotationMember.getName(), value));
                }
            }
        }
        return annotation;
    }

    private String parseParamValue(AnnotationDefinition annotationDefinition, String param, String value) {
        String result = value;
        if (result != null && (Description.class.getName().equals(annotationDefinition.getClassName()) || Label.class.getName().equals(annotationDefinition.getClassName()) || Timestamp.class.getName().equals(annotationDefinition.getClassName()) || Duration.class.getName().equals(annotationDefinition.getClassName()) || Expires.class.getName().equals(annotationDefinition.getClassName()))) {
            result = value;
        } else if (Position.class.getName().equals(annotationDefinition.getClassName())) {
            result = value;
        } else if (Role.class.getName().equals(annotationDefinition.getClassName())) {
            result = value != null && value.endsWith("FACT") ? "FACT" : (value != null && value.endsWith("EVENT") ? "EVENT" : value);
        }
        return result;
    }
}

