/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.KeyAnnotationDefinition;

public class DataModelUtils {
    public static boolean isAssignable(ObjectProperty property) {
        return property != null && !property.isFinal() && !property.isStatic();
    }

    public static boolean isKeyField(ObjectProperty property) {
        return property != null && property.getAnnotation(KeyAnnotationDefinition.getInstance().getClassName()) != null;
    }

    public static int keyFieldsCount(DataObject dataObject) {
        int result = 0;
        for (ObjectProperty property : dataObject.getProperties().values()) {
            if (!DataModelUtils.isKeyField(property)) continue;
            ++result;
        }
        return result;
    }

    public static int assignableFieldsCount(DataObject dataObject) {
        int result = 0;
        for (ObjectProperty property : dataObject.getProperties().values()) {
            if (!DataModelUtils.isAssignable(property)) continue;
            ++result;
        }
        return result;
    }
}

