/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.drools.core.base.ClassTypeResolver;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassOrInterfaceTypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierWithTypeArgumentsDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ImportDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;

public class DriverUtils {
    protected DriverUtils() {
    }

    public static DriverUtils getInstance() {
        return new DriverUtils();
    }

    public ClassTypeResolver createClassTypeResolver(FileDescr fileDescr, ClassLoader classLoader) {
        String packageName;
        HashSet<String> classImports = new HashSet<String>();
        List<ImportDescr> fileImports = fileDescr.getImports();
        if (fileImports != null) {
            for (ImportDescr importDescr : fileDescr.getImports()) {
                classImports.add(importDescr.getName(true));
            }
        }
        if ((packageName = fileDescr.getPackageDescr() != null ? fileDescr.getPackageDescr().getPackageName() : null) != null && !"".equals(packageName)) {
            classImports.add(packageName + ".*");
        }
        return new ClassTypeResolver(classImports, classLoader);
    }

    public ClassTypeResolver createClassTypeResolver(JavaClassSource javaClassSource, ClassLoader classLoader) {
        List innerTypes;
        String packageName;
        HashSet<String> classImports = new HashSet<String>();
        List imports = javaClassSource.getImports();
        if (imports != null) {
            for (Import currentImport : imports) {
                String importName = currentImport.getQualifiedName();
                if (currentImport.isWildcard()) {
                    importName = importName + ".*";
                }
                classImports.add(importName);
            }
        }
        if ((packageName = javaClassSource.getPackage()) != null && !"".equals(packageName)) {
            classImports.add(packageName + ".*");
        }
        if ((innerTypes = javaClassSource.getNestedTypes()) != null) {
            for (JavaSource type : innerTypes) {
                classImports.add(packageName + "." + javaClassSource.getName() + "." + type.getName());
            }
        }
        return new ClassTypeResolver(classImports, classLoader);
    }

    public boolean isPrimitiveType(TypeDescr typeDescr) {
        return typeDescr.isPrimitiveType();
    }

    public boolean isSimpleClass(TypeDescr typeDescr) {
        if (!typeDescr.isClassOrInterfaceType()) {
            return false;
        }
        ClassOrInterfaceTypeDescr classOrInterfaceTypeDescr = typeDescr.getClassOrInterfaceType();
        List<IdentifierWithTypeArgumentsDescr> identifierWithTypeArgumentsList = classOrInterfaceTypeDescr.getIdentifierWithTypeArguments();
        if (identifierWithTypeArgumentsList == null || identifierWithTypeArgumentsList.size() == 0) {
            return false;
        }
        for (IdentifierWithTypeArgumentsDescr identifierWithTypeArguments : identifierWithTypeArgumentsList) {
            if (identifierWithTypeArguments.getArguments() == null) continue;
            return false;
        }
        return true;
    }

    public Object[] isSimpleGeneric(TypeDescr typeDescr) {
        Object[] result = new Object[]{false, null, null};
        if (!typeDescr.isClassOrInterfaceType()) {
            return result;
        }
        ClassOrInterfaceTypeDescr classOrInterfaceTypeDescr = typeDescr.getClassOrInterfaceType();
        List<IdentifierWithTypeArgumentsDescr> identifierWithTypeArgumentsList = classOrInterfaceTypeDescr.getIdentifierWithTypeArguments();
        if (identifierWithTypeArgumentsList == null || identifierWithTypeArgumentsList.size() == 0) {
            return result;
        }
        int i = 0;
        StringBuilder outerClassName = new StringBuilder();
        for (IdentifierWithTypeArgumentsDescr identifierWithTypeArguments : identifierWithTypeArgumentsList) {
            List<TypeArgumentDescr> typeArguments;
            if (++i > 1) {
                outerClassName.append(".");
            }
            outerClassName.append(identifierWithTypeArguments.getIdentifier().getIdentifier());
            if (identifierWithTypeArguments.getArguments() == null) continue;
            if (identifierWithTypeArgumentsList.size() > i) {
                return result;
            }
            TypeArgumentListDescr typeArgumentList = identifierWithTypeArguments.getArguments();
            List<TypeArgumentDescr> list = typeArguments = typeArgumentList != null ? typeArgumentList.getArguments() : null;
            if (typeArguments == null || typeArguments.size() != 1) {
                return result;
            }
            TypeDescr type = typeArguments.get(0).getType();
            if (type == null || !this.isSimpleClass(type)) continue;
            result[0] = true;
            result[1] = outerClassName.toString();
            result[2] = type;
            return result;
        }
        return result;
    }

    public Object[] isSimpleGeneric(Type type, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        Object[] result = new Object[]{false, null, null};
        if (type.isArray() || type.isPrimitive() || !type.isParameterized() || type.isParameterized() && type.getTypeArguments().size() != 1) {
            return result;
        }
        Type argument = (Type)type.getTypeArguments().get(0);
        if (!this.isSimpleClass(argument)) {
            return result;
        }
        try {
            String outerClass = classTypeResolver.getFullTypeName(type.getName());
            String argumentClass = classTypeResolver.getFullTypeName(argument.getName());
            result[0] = true;
            result[1] = outerClass;
            result[2] = argumentClass;
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + type.getName() + ". " + e.getMessage(), e);
        }
    }

    public boolean isArray(TypeDescr typeDescr) {
        return typeDescr.getDimensionsCount() > 0;
    }

    public boolean isManagedType(TypeDescr typeDescr, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        DriverUtils driverUtils = DriverUtils.getInstance();
        if (driverUtils.isArray(typeDescr)) {
            return false;
        }
        if (driverUtils.isPrimitiveType(typeDescr) || driverUtils.isSimpleClass(typeDescr)) {
            return true;
        }
        Object[] simpleGenerics = driverUtils.isSimpleGeneric(typeDescr);
        if (Boolean.FALSE.equals(simpleGenerics[0])) {
            return false;
        }
        String collectionCandidate = simpleGenerics[1].toString();
        try {
            Class collectionCandidateClass = classTypeResolver.resolveType(collectionCandidate);
            return Collection.class.isAssignableFrom(collectionCandidateClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + collectionCandidate + ". " + e.getMessage(), e);
        }
    }

    public boolean isManagedType(Type type, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isParameterized() && type.getTypeArguments().size() > 1) {
            return false;
        }
        try {
            Class clazz = classTypeResolver.resolveType(type.getName());
            if (clazz.isEnum() || clazz.isAnonymousClass() || clazz.isLocalClass() || clazz.isMemberClass()) {
                return false;
            }
            if (type.isParameterized()) {
                Class bag = classTypeResolver.resolveType(type.getName());
                if (!Collection.class.isAssignableFrom(bag)) {
                    return false;
                }
                return this.isSimpleClass((Type)type.getTypeArguments().get(0));
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + type.getName() + ". " + e.getMessage(), e);
        }
    }

    public boolean isSimpleClass(Type<?> type) {
        return !type.isArray() && !type.isPrimitive() && !type.isParameterized();
    }

    public boolean equalsType(TypeDescr type, String fullClassName, boolean multiple, String fullBagClassName, ClassTypeResolver classTypeResolver) throws ClassNotFoundException {
        if (this.isArray(type)) {
            return false;
        }
        if (type.isPrimitiveType()) {
            return !multiple && fullClassName.equals(type.getPrimitiveType().getName());
        }
        if (this.isSimpleClass(type)) {
            String currentClassName = classTypeResolver.getFullTypeName(type.getClassOrInterfaceType().getClassName());
            return !multiple && fullClassName.equals(currentClassName);
        }
        Object[] simpleGenerics = this.isSimpleGeneric(type);
        if (Boolean.TRUE.equals(simpleGenerics[0]) && multiple) {
            String currentBag = (String)simpleGenerics[1];
            currentBag = classTypeResolver.getFullTypeName(currentBag);
            String currentClassName = ((TypeDescr)simpleGenerics[2]).getClassOrInterfaceType().getClassName();
            currentClassName = classTypeResolver.getFullTypeName(currentClassName);
            return fullBagClassName.equals(currentBag) && fullClassName.equals(currentClassName);
        }
        return false;
    }

    public boolean equalsType(Type type, String fullClassName, boolean multiple, String fullBagClassName, ClassTypeResolver classTypeResolver) throws Exception {
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return !multiple && fullClassName.equals(type.getName());
        }
        if (this.isSimpleClass(type)) {
            String currentClassName = classTypeResolver.getFullTypeName(type.getName());
            return !multiple && fullClassName.equals(currentClassName);
        }
        Object[] simpleGenerics = this.isSimpleGeneric(type, classTypeResolver);
        if (multiple && Boolean.TRUE.equals(simpleGenerics[0]) && this.isManagedType(type, classTypeResolver)) {
            String currentBag = (String)simpleGenerics[1];
            currentBag = classTypeResolver.getFullTypeName(currentBag);
            String currentClassName = (String)simpleGenerics[2];
            currentClassName = classTypeResolver.getFullTypeName(currentClassName);
            return fullBagClassName.equals(currentBag) && fullClassName.equals(currentClassName);
        }
        return false;
    }

    public int buildModifierRepresentation(List<ModifierDescr> modifiers) {
        int result = 0;
        if (modifiers != null) {
            for (ModifierDescr modifier : modifiers) {
                if ("public".equals(modifier.getName())) {
                    result |= 1;
                }
                if ("protected".equals(modifier.getName())) {
                    result |= 4;
                }
                if ("private".equals(modifier.getName())) {
                    result |= 2;
                }
                if ("abstract".equals(modifier.getName())) {
                    result |= 0x400;
                }
                if ("static".equals(modifier.getName())) {
                    result |= 8;
                }
                if ("final".equals(modifier.getName())) {
                    result |= 0x10;
                }
                if ("transient".equals(modifier.getName())) {
                    result |= 0x80;
                }
                if ("volatile".equals(modifier.getName())) {
                    result |= 0x40;
                }
                if ("synchronized".equals(modifier.getName())) {
                    result |= 0x20;
                }
                if ("native".equals(modifier.getName())) {
                    result |= 0x100;
                }
                if ("strictfp".equals(modifier.getName())) {
                    result |= 0x800;
                }
                if (!"interface".equals(modifier.getName())) continue;
                result |= 0x200;
            }
        }
        return result;
    }

    public int buildModifierRepresentation(Member<?> member) {
        int result = 0;
        result = this.addModifierRepresentation(result, member);
        result = this.addModifierRepresentation(result, (VisibilityScoped)member);
        return result;
    }

    public int buildModifierRepresentation(JavaClassSource classSource) {
        return this.addModifierRepresentation(0, (VisibilityScoped)classSource);
    }

    public int addModifierRepresentation(int modifiers, Member<?> member) {
        if (member != null) {
            if (member.isStatic()) {
                modifiers |= 8;
            }
            if (member.isFinal()) {
                modifiers |= 0x10;
            }
        }
        return modifiers;
    }

    public int addModifierRepresentation(int modifiers, VisibilityScoped visibilityScoped) {
        if (visibilityScoped != null) {
            if (visibilityScoped.isPublic()) {
                modifiers |= 1;
            }
            if (visibilityScoped.isProtected()) {
                modifiers |= 4;
            }
            if (visibilityScoped.isPrivate()) {
                modifiers |= 2;
            }
        }
        return modifiers;
    }
}

