/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.logging;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.jboss.solder.logging.internal.Logger;

public class Logger
implements Serializable {
    private static final long serialVersionUID = 2699068144024070551L;
    private final org.jboss.solder.logging.internal.Logger delegate;

    Logger(String name) {
        this.delegate = org.jboss.solder.logging.internal.Logger.getLogger((String)name);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isEnabled(Level level) {
        return this.delegate.isEnabled(Logger.translate(level));
    }

    public boolean isTraceEnabled() {
        return this.delegate.isEnabled(Logger.Level.TRACE);
    }

    public void trace(Object message) {
        this.delegate.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
    }

    public void trace(String loggerFqcn, Object message, Throwable t) {
        this.delegate.trace(loggerFqcn, message, t);
    }

    public void trace(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.trace(loggerFqcn, message, params, t);
    }

    public void tracev(String format, Object ... params) {
        this.delegate.tracev(format, params);
    }

    public void tracev(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(format, param1);
        }
    }

    public void tracev(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(format, param1, param2);
        }
    }

    public void tracev(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(format, param1, param2, param3);
        }
    }

    public void tracev(Throwable t, String format, Object ... params) {
        this.delegate.tracev(t, format, params);
    }

    public void tracev(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(t, format, param1);
        }
    }

    public void tracev(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(t, format, param1, param2);
        }
    }

    public void tracev(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracev(t, format, param1, param2, param3);
        }
    }

    public void tracef(String format, Object ... params) {
        this.delegate.tracef(format, params);
    }

    public void tracef(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(format, param1);
        }
    }

    public void tracef(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(format, param1, param2);
        }
    }

    public void tracef(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(format, param1, param2, param3);
        }
    }

    public void tracef(Throwable t, String format, Object ... params) {
        this.delegate.tracef(t, format, params);
    }

    public void tracef(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(t, format, param1);
        }
    }

    public void tracef(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(t, format, param1, param2);
        }
    }

    public void tracef(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.TRACE)) {
            this.delegate.tracef(t, format, param1, param2, param3);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isEnabled(Logger.Level.DEBUG);
    }

    public void debug(Object message) {
        this.delegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
    }

    public void debug(String loggerFqcn, Object message, Throwable t) {
        this.delegate.debug(loggerFqcn, message, t);
    }

    public void debug(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.debug(loggerFqcn, message, params, t);
    }

    public void debugv(String format, Object ... params) {
        this.delegate.debugv(format, params);
    }

    public void debugv(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(format, param1);
        }
    }

    public void debugv(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(format, param1, param2);
        }
    }

    public void debugv(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(format, param1, param2, param3);
        }
    }

    public void debugv(Throwable t, String format, Object ... params) {
        this.delegate.debugv(t, format, params);
    }

    public void debugv(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(t, format, param1);
        }
    }

    public void debugv(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(t, format, param1, param2);
        }
    }

    public void debugv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugv(t, format, param1, param2, param3);
        }
    }

    public void debugf(String format, Object ... params) {
        this.delegate.debugf(format, params);
    }

    public void debugf(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(format, param1);
        }
    }

    public void debugf(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(format, param1, param2);
        }
    }

    public void debugf(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(format, param1, param2, param3);
        }
    }

    public void debugf(Throwable t, String format, Object ... params) {
        this.delegate.debugf(t, format, params);
    }

    public void debugf(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(t, format, param1);
        }
    }

    public void debugf(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(t, format, param1, param2);
        }
    }

    public void debugf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.DEBUG)) {
            this.delegate.debugf(t, format, param1, param2, param3);
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate.isEnabled(Logger.Level.INFO);
    }

    public void info(Object message) {
        this.delegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(message, t);
    }

    public void info(String loggerFqcn, Object message, Throwable t) {
        this.delegate.info(loggerFqcn, message, t);
    }

    public void info(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.info(loggerFqcn, message, params, t);
    }

    public void infov(String format, Object ... params) {
        this.delegate.infov(format, params);
    }

    public void infov(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(format, param1);
        }
    }

    public void infov(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(format, param1, param2);
        }
    }

    public void infov(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(format, param1, param2, param3);
        }
    }

    public void infov(Throwable t, String format, Object ... params) {
        this.delegate.infov(t, format, params);
    }

    public void infov(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(t, format, param1);
        }
    }

    public void infov(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(t, format, param1, param2);
        }
    }

    public void infov(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infov(t, format, param1, param2, param3);
        }
    }

    public void infof(String format, Object ... params) {
        this.delegate.infof(format, params);
    }

    public void infof(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(format, param1);
        }
    }

    public void infof(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(format, param1, param2);
        }
    }

    public void infof(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(format, param1, param2, param3);
        }
    }

    public void infof(Throwable t, String format, Object ... params) {
        this.delegate.infof(t, format, params);
    }

    public void infof(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(t, format, param1);
        }
    }

    public void infof(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(t, format, param1, param2);
        }
    }

    public void infof(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.INFO)) {
            this.delegate.infof(t, format, param1, param2, param3);
        }
    }

    public void warn(Object message) {
        this.delegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn(message, t);
    }

    public void warn(String loggerFqcn, Object message, Throwable t) {
        this.delegate.warn(loggerFqcn, message, t);
    }

    public void warn(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.warn(loggerFqcn, message, params, t);
    }

    public void warnv(String format, Object ... params) {
        this.delegate.warnv(format, params);
    }

    public void warnv(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(format, param1);
        }
    }

    public void warnv(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(format, param1, param2);
        }
    }

    public void warnv(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(format, param1, param2, param3);
        }
    }

    public void warnv(Throwable t, String format, Object ... params) {
        this.delegate.warnv(t, format, params);
    }

    public void warnv(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(t, format, param1);
        }
    }

    public void warnv(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(t, format, param1, param2);
        }
    }

    public void warnv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnv(t, format, param1, param2, param3);
        }
    }

    public void warnf(String format, Object ... params) {
        this.delegate.warnf(format, params);
    }

    public void warnf(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(format, param1);
        }
    }

    public void warnf(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(format, param1, param2);
        }
    }

    public void warnf(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(format, param1, param2, param3);
        }
    }

    public void warnf(Throwable t, String format, Object ... params) {
        this.delegate.warnf(t, format, params);
    }

    public void warnf(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(t, format, param1);
        }
    }

    public void warnf(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(t, format, param1, param2);
        }
    }

    public void warnf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.WARN)) {
            this.delegate.warnf(t, format, param1, param2, param3);
        }
    }

    public void error(Object message) {
        this.delegate.error(message);
    }

    public void error(Object message, Throwable t) {
        this.delegate.error(message, t);
    }

    public void error(String loggerFqcn, Object message, Throwable t) {
        this.delegate.error(loggerFqcn, message, t);
    }

    public void error(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.error(loggerFqcn, message, params, t);
    }

    public void errorv(String format, Object ... params) {
        this.delegate.errorv(format, params);
    }

    public void errorv(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(format, param1);
        }
    }

    public void errorv(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(format, param1, param2);
        }
    }

    public void errorv(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(format, param1, param2, param3);
        }
    }

    public void errorv(Throwable t, String format, Object ... params) {
        this.delegate.errorv(t, format, params);
    }

    public void errorv(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(t, format, param1);
        }
    }

    public void errorv(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(t, format, param1, param2);
        }
    }

    public void errorv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorv(t, format, param1, param2, param3);
        }
    }

    public void errorf(String format, Object ... params) {
        this.delegate.errorf(format, params);
    }

    public void errorf(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(format, param1);
        }
    }

    public void errorf(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(format, param1, param2);
        }
    }

    public void errorf(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(format, param1, param2, param3);
        }
    }

    public void errorf(Throwable t, String format, Object ... params) {
        this.delegate.errorf(t, format, params);
    }

    public void errorf(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(t, format, param1);
        }
    }

    public void errorf(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(t, format, param1, param2);
        }
    }

    public void errorf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.ERROR)) {
            this.delegate.errorf(t, format, param1, param2, param3);
        }
    }

    public void fatal(Object message) {
        this.delegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
    }

    public void fatal(String loggerFqcn, Object message, Throwable t) {
        this.delegate.fatal(loggerFqcn, message, t);
    }

    public void fatal(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.delegate.fatal(loggerFqcn, message, params, t);
    }

    public void fatalv(String format, Object ... params) {
        this.delegate.fatalv(format, params);
    }

    public void fatalv(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(format, param1);
        }
    }

    public void fatalv(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(format, param1, param2);
        }
    }

    public void fatalv(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(format, param1, param2, param3);
        }
    }

    public void fatalv(Throwable t, String format, Object ... params) {
        this.delegate.fatalv(t, format, params);
    }

    public void fatalv(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(t, format, param1);
        }
    }

    public void fatalv(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(t, format, param1, param2);
        }
    }

    public void fatalv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalv(t, format, param1, param2, param3);
        }
    }

    public void fatalf(String format, Object ... params) {
        this.delegate.fatalf(format, params);
    }

    public void fatalf(String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(format, param1);
        }
    }

    public void fatalf(String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(format, param1, param2);
        }
    }

    public void fatalf(String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(format, param1, param2, param3);
        }
    }

    public void fatalf(Throwable t, String format, Object ... params) {
        this.delegate.fatalf(t, format, params);
    }

    public void fatalf(Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(t, format, param1);
        }
    }

    public void fatalf(Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(t, format, param1, param2);
        }
    }

    public void fatalf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.Level.FATAL)) {
            this.delegate.fatalf(t, format, param1, param2, param3);
        }
    }

    public void log(Level level, Object message) {
        this.delegate.log(Logger.translate(level), message);
    }

    public void log(Level level, Object message, Throwable t) {
        this.delegate.log(Logger.translate(level), message, t);
    }

    public void log(Level level, String loggerFqcn, Object message, Throwable t) {
        this.delegate.log(Logger.translate(level), loggerFqcn, message, t);
    }

    public void log(String loggerFqcn, Level level, Object message, Object[] params, Throwable t) {
        this.delegate.log(loggerFqcn, Logger.translate(level), message, params, t);
    }

    public void logv(Level level, String format, Object ... params) {
        this.delegate.logv(Logger.translate(level), format, params);
    }

    public void logv(Level level, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), format, param1);
        }
    }

    public void logv(Level level, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), format, param1, param2);
        }
    }

    public void logv(Level level, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), format, param1, param2, param3);
        }
    }

    public void logv(Level level, Throwable t, String format, Object ... params) {
        this.delegate.logv(Logger.translate(level), t, format, params);
    }

    public void logv(Level level, Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), t, format, param1);
        }
    }

    public void logv(Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), t, format, param1, param2);
        }
    }

    public void logv(Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(Logger.translate(level), t, format, param1, param2, param3);
        }
    }

    public void logv(String loggerFqcn, Level level, Throwable t, String format, Object ... params) {
        this.delegate.logv(loggerFqcn, Logger.translate(level), t, format, params);
    }

    public void logv(String loggerFqcn, Level level, Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(loggerFqcn, Logger.translate(level), t, format, param1);
        }
    }

    public void logv(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(loggerFqcn, Logger.translate(level), t, format, param1, param2);
        }
    }

    public void logv(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logv(loggerFqcn, Logger.translate(level), t, format, param1, param2, param3);
        }
    }

    public void logf(Level level, String format, Object ... params) {
        this.delegate.logf(Logger.translate(level), format, params);
    }

    public void logf(Level level, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), format, param1);
        }
    }

    public void logf(Level level, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), format, param1, param2);
        }
    }

    public void logf(Level level, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), format, param1, param2, param3);
        }
    }

    public void logf(Level level, Throwable t, String format, Object ... params) {
        this.delegate.logf(Logger.translate(level), t, format, params);
    }

    public void logf(Level level, Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), t, format, param1);
        }
    }

    public void logf(Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), t, format, param1, param2);
        }
    }

    public void logf(Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(Logger.translate(level), t, format, param1, param2, param3);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(loggerFqcn, Logger.translate(level), t, format, param1);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(loggerFqcn, Logger.translate(level), t, format, param1, param2);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (this.delegate.isEnabled(Logger.translate(level))) {
            this.delegate.logf(loggerFqcn, Logger.translate(level), t, format, param1, param2, param3);
        }
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object ... params) {
        this.delegate.logf(loggerFqcn, Logger.translate(level), t, format, params);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(String name, String suffix) {
        return Logger.getLogger(name == null || name.length() == 0 ? suffix : name + "." + suffix);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class<?> clazz, String suffix) {
        return Logger.getLogger(clazz.getName(), suffix);
    }

    public static <T> T getMessageLogger(Class<T> type, String category) {
        return Logger.getMessageLogger(type, category, Locale.getDefault());
    }

    public static <T> T getMessageLogger(Class<T> type, String category, Locale locale) {
        Constructor constructor;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Class<T> loggerClass = null;
        if (variant != null && variant.length() > 0) {
            try {
                loggerClass = Class.forName(Logger.join(type.getName(), "$logger", language, country, variant), true, type.getClassLoader()).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (loggerClass == null && country != null && country.length() > 0) {
            try {
                loggerClass = Class.forName(Logger.join(type.getName(), "$logger", language, country, null), true, type.getClassLoader()).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (loggerClass == null && language != null && language.length() > 0) {
            try {
                loggerClass = Class.forName(Logger.join(type.getName(), "$logger", language, null, null), true, type.getClassLoader()).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (loggerClass == null) {
            try {
                loggerClass = Class.forName(Logger.join(type.getName(), "$logger", null, null, null), true, type.getClassLoader()).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid logger " + type + " (implementation not found)");
            }
        }
        try {
            constructor = loggerClass.getConstructor(Logger.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Logger implementation " + loggerClass + " has no matching constructor");
        }
        try {
            return constructor.newInstance(Logger.getLogger(category));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Logger implementation " + loggerClass + " could not be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Logger implementation " + loggerClass + " could not be instantiated", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Logger implementation " + loggerClass + " could not be instantiated", e.getCause());
        }
    }

    private static String join(String interfaceName, String a, String b, String c, String d) {
        StringBuilder build = new StringBuilder();
        build.append(interfaceName).append('_').append(a);
        if (b != null && b.length() > 0) {
            build.append('_');
            build.append(b);
        }
        if (c != null && c.length() > 0) {
            build.append('_');
            build.append(c);
        }
        if (d != null && d.length() > 0) {
            build.append('_');
            build.append(d);
        }
        return build.toString();
    }

    private static Logger.Level translate(Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return Logger.Level.FATAL;
                }
                case ERROR: {
                    return Logger.Level.ERROR;
                }
                case WARN: {
                    return Logger.Level.WARN;
                }
                case INFO: {
                    return Logger.Level.INFO;
                }
                case DEBUG: {
                    return Logger.Level.DEBUG;
                }
                case TRACE: {
                    return Logger.Level.TRACE;
                }
            }
        }
        return null;
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

