/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport.asset;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.AssetImporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.AttachmentAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;

public class AttachmentAssetImporter
implements AssetImporter<AttachmentAsset> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    FileManager fileManager;

    @Override
    public org.uberfire.backend.vfs.Path importAsset(Module xmlModule, AttachmentAsset xmlAsset, org.uberfire.backend.vfs.Path previousVersionPath) {
        String extension = StringUtils.isNotBlank((CharSequence)xmlAsset.getOriginalFormat()) ? xmlAsset.getOriginalFormat() : xmlAsset.getAssetType().toString();
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForAsset(xmlModule, (XmlAsset)xmlAsset, extension);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (previousVersionPath != null && !previousVersionPath.equals(path)) {
            this.ioService.move(Paths.convert((org.uberfire.backend.vfs.Path)previousVersionPath), nioPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        String attachmentFileName = xmlAsset.getAttachmentFileName();
        byte[] attachment = this.fileManager.readBinaryContent(attachmentFileName);
        this.ioService.write(nioPath, attachment, (Map)null, new OpenOption[]{new CommentedOption(xmlAsset.getLastContributor(), null, xmlAsset.getCheckinComment(), xmlAsset.getLastModified())});
        return path;
    }
}

