/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.AttachmentAsset;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttachmentAssetFormat
extends XmlAssetFormat {
    private static final String ORIGINAL_FORMAT = "originalFormat";
    private static final String ATTACHMENT_FILENAME = "attachmentFileName";

    protected String doFormat(AttachmentAsset attachmentAsset) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)attachmentAsset.getOriginalFormat())) {
            sb.append("<").append(ORIGINAL_FORMAT).append(">").append(attachmentAsset.getOriginalFormat()).append("</").append(ORIGINAL_FORMAT).append(">");
        }
        sb.append("<").append(ATTACHMENT_FILENAME).append(">").append(attachmentAsset.getAttachmentFileName()).append("</").append(ATTACHMENT_FILENAME).append(">");
        return sb.toString();
    }

    protected AttachmentAsset doParse(String name, String format, String lastContributor, String checkinComment, Date lastModified, Node assetNode) {
        String originalFormat = null;
        String attachmentFile = null;
        NodeList assetNodeList = assetNode.getChildNodes();
        for (int i = 0; i < assetNodeList.getLength(); ++i) {
            Node node = assetNodeList.item(i);
            String nodeContent = node.getTextContent();
            if (ORIGINAL_FORMAT.equalsIgnoreCase(node.getNodeName())) {
                originalFormat = nodeContent;
                continue;
            }
            if (!ATTACHMENT_FILENAME.equalsIgnoreCase(node.getNodeName())) continue;
            attachmentFile = nodeContent;
        }
        return new AttachmentAsset(name, format, lastContributor, checkinComment, lastModified, originalFormat, attachmentFile);
    }
}

