/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RefactoringQueryServiceImpl
implements RefactoringQueryService {
    private LuceneConfig config;
    private Set<NamedQuery> namedQueries = new HashSet<NamedQuery>();
    private PageResponse<RefactoringPageRow> emptyResponse;

    public RefactoringQueryServiceImpl() {
    }

    @Inject
    public RefactoringQueryServiceImpl(@Named(value="luceneConfig") LuceneConfig config, @Any Instance<NamedQuery> namedQueries) {
        this.config = (LuceneConfig)PortablePreconditions.checkNotNull((String)"config", (Object)config);
        PortablePreconditions.checkNotNull((String)"namedQueries", namedQueries);
        for (NamedQuery namedQuery : namedQueries) {
            this.namedQueries.add(namedQuery);
        }
    }

    @PostConstruct
    public void init() {
        this.emptyResponse = new PageResponse();
        this.emptyResponse.setPageRowList(Collections.emptyList());
        this.emptyResponse.setStartRowIndex(0);
        this.emptyResponse.setTotalRowSize(0);
        this.emptyResponse.setLastPage(true);
        this.emptyResponse.setTotalRowSizeExact(true);
    }

    public Set<String> getQueries() {
        HashSet<String> queryNames = new HashSet<String>();
        for (NamedQuery namedQuery : this.namedQueries) {
            queryNames.add(namedQuery.getName());
        }
        return queryNames;
    }

    public Set<IndexTerm> getTerms(String queryName) {
        for (NamedQuery namedQuery : this.namedQueries) {
            if (!namedQuery.getName().equals(queryName)) continue;
            return namedQuery.getTerms();
        }
        throw new IllegalArgumentException("Named Query '" + queryName + "' does not exist.");
    }

    public PageResponse<RefactoringPageRow> query(RefactoringPageRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        String queryName = (String)PortablePreconditions.checkNotNull((String)"queryName", (Object)request.getQueryName());
        NamedQuery namedQuery = null;
        for (NamedQuery nq : this.namedQueries) {
            if (!nq.getName().equals(queryName)) continue;
            namedQuery = nq;
            break;
        }
        if (namedQuery == null) {
            throw new IllegalArgumentException("Named Query '" + queryName + "' does not exist.");
        }
        Set<IndexTerm> namedQueryTerms = namedQuery.getTerms();
        Set queryTerms = request.getQueryTerms();
        for (IndexTerm term : namedQueryTerms) {
            if (this.valueTermsContainsRequiredTerm(queryTerms, term)) continue;
            throw new IllegalArgumentException("Expected IndexTerm '" + term.getTerm() + "' was not found.");
        }
        for (IndexTerm term : queryTerms) {
            if (this.requiredTermsContainsValueTerm(namedQueryTerms, (ValueIndexTerm)term)) continue;
        }
        Query query = namedQuery.toQuery(queryTerms, request.useWildcards());
        int hits = this.searchHits(query, new ClusterSegment[0]);
        if (hits > 0) {
            int pageSize = request.getPageSize();
            int startIndex = request.getStartRowIndex();
            List<KObject> kObjects = this.search(query, pageSize, startIndex, new ClusterSegment[0]);
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(pageSize, startIndex, kObjects);
        }
        return this.emptyResponse;
    }

    public List<RefactoringPageRow> query(String queryName, Set<ValueIndexTerm> queryTerms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"queryName", (Object)queryName);
        PortablePreconditions.checkNotNull((String)"queryTerms", queryTerms);
        NamedQuery namedQuery = null;
        for (NamedQuery nq : this.namedQueries) {
            if (!nq.getName().equals(queryName)) continue;
            namedQuery = nq;
            break;
        }
        if (namedQuery == null) {
            throw new IllegalArgumentException("Named Query '" + queryName + "' does not exist.");
        }
        Set<IndexTerm> namedQueryTerms = namedQuery.getTerms();
        for (IndexTerm indexTerm : namedQueryTerms) {
            if (this.valueTermsContainsRequiredTerm(queryTerms, indexTerm)) continue;
            throw new IllegalArgumentException("Expected IndexTerm '" + indexTerm.getTerm() + "' was not found.");
        }
        for (ValueIndexTerm valueIndexTerm : queryTerms) {
            if (this.requiredTermsContainsValueTerm(namedQueryTerms, valueIndexTerm)) continue;
        }
        Query query = namedQuery.toQuery(queryTerms, useWildcards);
        int n = this.searchHits(query, new ClusterSegment[0]);
        if (n > 0) {
            List<KObject> kObjects = this.search(query, n, new ClusterSegment[0]);
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(kObjects);
        }
        return Collections.emptyList();
    }

    private boolean valueTermsContainsRequiredTerm(Set<ValueIndexTerm> providedTerms, IndexTerm requiredTerm) {
        for (ValueIndexTerm valueTerm : providedTerms) {
            if (!valueTerm.getTerm().equals(requiredTerm.getTerm())) continue;
            return true;
        }
        return false;
    }

    private boolean requiredTermsContainsValueTerm(Set<IndexTerm> requiredTerms, ValueIndexTerm providedTerm) {
        for (IndexTerm valueTerm : requiredTerms) {
            if (!valueTerm.getTerm().equals(providedTerm.getTerm())) continue;
            return true;
        }
        return false;
    }

    private int searchHits(Query query, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            index.search(query, (Collector)collector);
            int n = collector.getTotalHits();
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
    }

    private List<KObject> search(Query query, int pageSize, int startIndex, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)((startIndex + 1) * pageSize), (boolean)true);
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>(pageSize);
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs((int)startIndex).scoreDocs;
            int iterations = hits.length > pageSize ? pageSize : hits.length;
            for (int i = 0; i < iterations; ++i) {
                result.add(KObjectUtil.toKObject((Document)index.doc(hits[i].doc)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
        return result;
    }

    private List<KObject> search(Query query, int totalHits, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)totalHits, (boolean)true);
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>();
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                result.add(KObjectUtil.toKObject((Document)index.doc(hits[i].doc)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
        return result;
    }
}

