/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.RuleAttributeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.RuleAttributeValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindRuleAttributesQuery
implements NamedQuery {
    @Inject
    private DefaultResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return "FindRuleAttributesQuery";
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new RuleAttributeIndexTerm());
                this.add(new RuleAttributeValueIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Required terms have not been provided. Require 'rule_attribute' and 'rule_attribute_value'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm ruleAttributeTerm = normalizedTerms.get("rule_attribute");
        ValueIndexTerm ruleAttributeValueTerm = normalizedTerms.get("rule_attribute_value");
        if (ruleAttributeTerm == null || ruleAttributeValueTerm == null) {
            throw new IllegalArgumentException("Required terms have not been provided. Require 'rule_attribute' and 'rule_attribute_value'.");
        }
        QueryBuilder builder = new QueryBuilder();
        if (useWildcards) {
            builder.useWildcards();
        }
        builder.addTerm(ruleAttributeTerm).addTerm(ruleAttributeValueTerm);
        return builder.build();
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

