/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.social.OrganizationalUnitEventType;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

@ApplicationScoped
public class UpdatedOrganizationalUnitEventAdapter
implements SocialAdapter<UpdatedOrganizationalUnitEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;

    public Class<UpdatedOrganizationalUnitEvent> eventToIntercept() {
        return UpdatedOrganizationalUnitEvent.class;
    }

    public SocialEventType socialEventType() {
        return OrganizationalUnitEventType.ORGANIZATIONAL_UNIT_UPDATED;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        UpdatedOrganizationalUnitEvent event = (UpdatedOrganizationalUnitEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.findSocialUser(event.getSessionInfo().getIdentity().getIdentifier()), this.socialEventType().name(), new Date()).withDescription(event.getOrganizationalUnit().getName()).withLink(event.getOrganizationalUnit().getName(), event.getOrganizationalUnit().getName(), SocialActivitiesEvent.LINK_TYPE.CUSTOM).withAdicionalInfo(new String[]{this.getAdditionalInfo(event)}).withParam("ouName", event.getOrganizationalUnit().getName());
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(UpdatedOrganizationalUnitEvent event) {
        return "updated";
    }
}

