/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.log4j.Logger;

public class PerformanceHealthReportProvider
extends HealthReportProvider {
    private static final Logger _logger = Logger.getLogger(PerformanceHealthReportProvider.class);
    public static final String _testStat = "testStat";
    public static final String _readLatencyStat = "readLatencyStat";
    public static final String _requestCountStat = "requestCountStat";
    public static final String _partitionRequestCountStat = "partitionRequestCountStat";
    public static final String _performanceCounters = "performanceCounters";
    public int readLatencyCount = 0;
    public double readLatencySum = 0.0;
    public int requestCount = 0;
    private final Map<String, HashMap<String, String>> _partitionStatMaps = new HashMap<String, HashMap<String, String>>();

    @Override
    public Map<String, String> getRecentHealthReport() {
        long testStat = 10L;
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(_testStat, "" + testStat);
        result.put(_readLatencyStat, "" + this.readLatencySum / (double)this.readLatencyCount);
        result.put(_requestCountStat, "" + this.requestCount);
        return result;
    }

    @Override
    public Map<String, Map<String, String>> getRecentPartitionHealthReport() {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        for (String statName : this._partitionStatMaps.keySet()) {
            result.put(statName, this._partitionStatMaps.get(statName));
        }
        return result;
    }

    HashMap<String, String> getStatMap(String statName, boolean createIfMissing) {
        HashMap<String, String> statMap;
        if (!this._partitionStatMaps.containsKey(statName)) {
            if (!createIfMissing) {
                return null;
            }
            statMap = new HashMap();
            this._partitionStatMaps.put(statName, statMap);
        } else {
            statMap = this._partitionStatMaps.get(statName);
        }
        return statMap;
    }

    String getPartitionStat(HashMap<String, String> partitionMap, String partitionName) {
        return partitionMap.get(partitionName);
    }

    void setPartitionStat(HashMap<String, String> partitionMap, String partitionName, String value) {
        partitionMap.put(partitionName, value);
    }

    public void incrementPartitionStat(String statName, String partitionName) {
        double currVal;
        HashMap<String, String> statMap = this.getStatMap(statName, true);
        String currValStr = this.getPartitionStat(statMap, partitionName);
        if (currValStr == null) {
            currVal = 1.0;
        } else {
            currVal = Double.parseDouble(this.getPartitionStat(statMap, partitionName));
            currVal += 1.0;
        }
        this.setPartitionStat(statMap, partitionName, String.valueOf(currVal));
    }

    public void submitPartitionStat(String statName, String partitionName, String value) {
        HashMap<String, String> statMap = this.getStatMap(statName, true);
        this.setPartitionStat(statMap, partitionName, value);
    }

    public String getPartitionStat(String statName, String partitionName) {
        HashMap<String, String> statMap = this.getStatMap(statName, false);
        if (statMap == null) {
            return null;
        }
        return statMap.get(partitionName);
    }

    @Override
    public void resetStats() {
        this._partitionStatMaps.clear();
    }

    @Override
    public String getReportName() {
        return _performanceCounters;
    }
}

