/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptorInvocation;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorReference;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInterceptorMetadata<T>
implements InterceptorMetadata<T>,
Serializable {
    private static final long serialVersionUID = 1247010247012491L;
    private final Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap;
    private final InterceptorReference<T> interceptorReference;
    private final boolean targetClass;

    public SimpleInterceptorMetadata(InterceptorReference<T> interceptorReference, boolean targetClass, Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap) {
        this.interceptorReference = interceptorReference;
        this.targetClass = targetClass;
        this.interceptorMethodMap = interceptorMethodMap;
    }

    @Override
    public ClassMetadata<?> getInterceptorClass() {
        return this.interceptorReference.getClassMetadata();
    }

    @Override
    public InterceptorReference<T> getInterceptorReference() {
        return this.interceptorReference;
    }

    public List<MethodMetadata> getInterceptorMethods(InterceptionType interceptionType) {
        if (this.interceptorMethodMap != null) {
            List<MethodMetadata> methods = this.interceptorMethodMap.get((Object)interceptionType);
            return methods == null ? Collections.emptyList() : methods;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEligible(InterceptionType interceptionType) {
        if (this.interceptorMethodMap == null) {
            return false;
        }
        List<MethodMetadata> interceptorMethods = this.interceptorMethodMap.get((Object)interceptionType);
        return interceptorMethods != null && !interceptorMethods.isEmpty();
    }

    @Override
    public InterceptorInvocation getInterceptorInvocation(Object interceptorInstance, InterceptorMetadata interceptorReference, InterceptionType interceptionType) {
        return new SimpleInterceptorInvocation<Object>(interceptorInstance, interceptionType, this.getInterceptorMethods(interceptionType), this.targetClass);
    }
}

