/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.guvnor.m2repo.backend.server.helpers.HttpGetHelper;
import org.guvnor.m2repo.backend.server.helpers.HttpPostHelper;
import org.guvnor.m2repo.backend.server.helpers.HttpPutHelper;
import org.guvnor.m2repo.backend.server.helpers.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.server.BaseFilteredServlet;

public class M2Servlet
extends BaseFilteredServlet {
    private static final Logger log = LoggerFactory.getLogger(M2Servlet.class);
    @Inject
    private HttpPostHelper httpPostHelper;
    @Inject
    private HttpPutHelper httpPutHelper;
    @Inject
    private HttpGetHelper httpGetHelper;

    protected void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        log.info("GET request received for " + request.getPathInfo());
        this.httpGetHelper.handle(new SecurityFilter(){

            @Override
            public boolean filter(URI uri) {
                return M2Servlet.this.validateAccess(uri, response);
            }
        }, request, response, this.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("POST request received.");
        this.httpPostHelper.handle(request, response);
    }

    protected void doPut(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        log.info("PUT request received for " + request.getPathInfo());
        this.httpPutHelper.handle(new SecurityFilter(){

            @Override
            public boolean filter(URI uri) {
                return M2Servlet.this.validateAccess(uri, response);
            }
        }, request, response);
    }
}

