/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.AfterAssetEditorCheckInEvent;
import org.drools.guvnor.client.asseteditor.DefaultMultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.asseteditor.GuvnorEditor;
import org.drools.guvnor.client.asseteditor.MultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.asseteditor.MultiViewRow;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.RuleViewerSettings;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.MultiAssetPlace;
import org.drools.guvnor.client.explorer.RefreshModuleDataModelEvent;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.explorer.RefreshSuggestionCompletionEngineEvent;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.util.LazyStackPanel;
import org.drools.guvnor.client.util.LoadContentCommand;
import org.drools.guvnor.client.widgets.CheckinPopup;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;

public class MultiViewEditor
extends GuvnorEditor {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final ClientFactory clientFactory;
    private VerticalPanel viewsPanel = new VerticalPanel();
    private Command closeCommand;
    private final Set<MultiViewRow> rows = new HashSet<MultiViewRow>();
    private Map<String, RuleViewer> ruleViews = new HashMap<String, RuleViewer>();
    private ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider;
    private Map<String, Asset> assets = new HashMap<String, Asset>();
    private MultiViewEditorMenuBarCreator menuBarCreator;
    private final EventBus eventBus;

    public MultiViewEditor(MultiViewRow[] rows, ClientFactory clientFactory, EventBus eventBus) {
        this(rows, clientFactory, eventBus, null);
    }

    public MultiViewEditor(MultiViewRow[] rows, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this(Arrays.asList(rows), clientFactory, eventBus, individualActionToolbarButtonsConfigurationProvider);
    }

    public MultiViewEditor(List<MultiViewRow> rows, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this.rows.addAll(rows);
        this.individualActionToolbarButtonsConfigurationProvider = individualActionToolbarButtonsConfigurationProvider;
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.init();
    }

    public MultiViewEditor(Asset[] assets, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this(assets, clientFactory, eventBus, individualActionToolbarButtonsConfigurationProvider, null);
    }

    public MultiViewEditor(Asset[] assets, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider, MultiViewEditorMenuBarCreator menuBarCreator) {
        this.rows.addAll(MultiViewEditor.createRows(assets));
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.individualActionToolbarButtonsConfigurationProvider = individualActionToolbarButtonsConfigurationProvider;
        this.menuBarCreator = menuBarCreator;
        this.addAssets(assets);
        this.init();
    }

    private void addAssets(Asset[] assets) {
        for (Asset ruleAsset : assets) {
            this.assets.put(ruleAsset.getUuid(), ruleAsset);
        }
    }

    private static List<MultiViewRow> createRows(Asset[] assets) {
        ArrayList<MultiViewRow> rows = new ArrayList<MultiViewRow>();
        for (Asset ruleAsset : assets) {
            MultiViewRow row = new MultiViewRow(ruleAsset.getUuid(), ruleAsset.getName(), "brl");
            rows.add(row);
        }
        return rows;
    }

    private void init() {
        VerticalPanel rootPanel = new VerticalPanel();
        rootPanel.setWidth("100%");
        rootPanel.add((Widget)this.createToolbar());
        this.viewsPanel.setWidth("100%");
        rootPanel.add((Widget)this.viewsPanel);
        this.doViews();
        this.initWidget((Widget)rootPanel);
    }

    private MenuBar createToolbar() {
        if (this.menuBarCreator == null) {
            this.menuBarCreator = new DefaultMultiViewEditorMenuBarCreator();
        }
        return this.menuBarCreator.createMenuBar(this, this.eventBus);
    }

    private void doViews() {
        this.viewsPanel.clear();
        this.ruleViews.clear();
        LazyStackPanel panel = new LazyStackPanel();
        int rowNumber = 1;
        for (final MultiViewRow row : this.rows) {
            panel.add(row.getName(), new LoadContentCommand(){

                @Override
                public Widget load() {
                    final SimplePanel content = new SimplePanel();
                    if (MultiViewEditor.this.assets.containsKey(row.getUuid())) {
                        MultiViewEditor.this.addRuleViewInToSimplePanel(row, content, (Asset)MultiViewEditor.this.assets.get(row.getUuid()));
                    } else {
                        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
                        assetService.loadRuleAsset(row.getUuid(), (AsyncCallback<Asset>)new GenericCallback<Asset>(){

                            public void onSuccess(Asset asset) {
                                MultiViewEditor.this.assets.put(asset.getUuid(), asset);
                                MultiViewEditor.this.addRuleViewInToSimplePanel(row, content, asset);
                            }
                        });
                    }
                    return content;
                }
            }, rowNumber == 1);
            ++rowNumber;
        }
        this.viewsPanel.add((Widget)panel);
    }

    private void addRuleViewInToSimplePanel(final MultiViewRow row, final SimplePanel content, final Asset asset) {
        this.eventBus.fireEvent((GwtEvent)new RefreshModuleDataModelEvent(asset.getMetaData().getModuleName(), new Command(){

            public void execute() {
                RuleViewerSettings ruleViewerSettings = new RuleViewerSettings();
                ruleViewerSettings.setDocoVisible(false);
                ruleViewerSettings.setMetaVisible(false);
                ruleViewerSettings.setStandalone(true);
                Command closeCommand = new Command(){

                    public void execute() {
                        MultiViewEditor.this.ruleViews.remove(row.getUuid());
                        MultiViewEditor.this.rows.remove(row);
                        MultiViewEditor.this.doViews();
                    }
                };
                RuleViewer ruleViewer = new RuleViewer(asset, MultiViewEditor.this.clientFactory, MultiViewEditor.this.eventBus, ruleViewerSettings);
                content.add((Widget)ruleViewer);
                ruleViewer.setWidth("100%");
                ruleViewer.setHeight("100%");
                MultiViewEditor.this.ruleViews.put(row.getUuid(), ruleViewer);
            }
        }));
    }

    public void checkin(final boolean closeAfter) {
        final CheckinPopup pop = new CheckinPopup(this.constants.CheckInChanges());
        pop.setCommand(new Command(){

            public void execute() {
                String comment = pop.getCheckinComment();
                for (RuleViewer ruleViewer : MultiViewEditor.this.ruleViews.values()) {
                    MultiViewEditor.this.doCheckin(ruleViewer.getAssetEditor(), ruleViewer.asset, comment, false);
                }
                if (closeAfter) {
                    MultiViewEditor.this.close();
                }
            }
        });
        pop.show();
    }

    public void doCheckin(final Widget editor, final Asset asset, final String comment, final boolean closeAfter) {
        if (editor instanceof SaveEventListener) {
            ((SaveEventListener)editor).onSave(new SaveCommand(){

                @Override
                public void save() {
                    MultiViewEditor.this.save(comment, closeAfter, asset, editor);
                }

                @Override
                public void cancel() {
                }
            });
        } else {
            this.save(comment, closeAfter, asset, editor);
        }
    }

    private void save(String comment, boolean closeAfter, Asset asset, Widget editor) {
        this.performCheckIn(comment, closeAfter, asset);
        if (editor instanceof SaveEventListener) {
            ((SaveEventListener)editor).onAfterSave();
        }
        this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(asset.getMetaData().getModuleUUID()));
    }

    private void performCheckIn(String comment, final boolean closeAfter, final Asset asset) {
        asset.setCheckinComment(comment);
        final boolean[] saved = new boolean[]{false};
        if (!saved[0]) {
            LoadingPopup.showMessage(this.constants.SavingPleaseWait());
        }
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.checkinVersion(asset, (AsyncCallback<String>)new GenericCallback<String>(){

            public void onSuccess(String uuid) {
                if (uuid == null) {
                    ErrorPopup.showMessage(MultiViewEditor.this.constants.FailedToCheckInTheItemPleaseContactYourSystemAdministrator());
                    return;
                }
                if (uuid.startsWith("ERR")) {
                    ErrorPopup.showMessage(uuid.substring(5));
                    return;
                }
                MultiViewEditor.this.flushSuggestionCompletionCache(asset.getMetaData().getModuleName(), asset);
                LoadingPopup.close();
                saved[0] = true;
                if (!closeAfter) {
                    MultiViewEditor.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(asset.getMetaData().getModuleName(), uuid));
                }
                MultiViewEditor.this.eventBus.fireEvent((GwtEvent)new AfterAssetEditorCheckInEvent(uuid, MultiViewEditor.this));
            }
        });
    }

    public void flushSuggestionCompletionCache(final String packageName, Asset asset) {
        if (AssetFormats.isPackageDependency(asset.getFormat())) {
            LoadingPopup.showMessage(this.constants.RefreshingContentAssistance());
            this.eventBus.fireEvent((GwtEvent)new RefreshModuleDataModelEvent(packageName, new Command(){

                public void execute() {
                    MultiViewEditor.this.eventBus.fireEvent((GwtEvent)new RefreshSuggestionCompletionEngineEvent(packageName));
                    LoadingPopup.close();
                }
            }));
        }
    }

    public void close() {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent(new MultiAssetPlace(this.rows)));
        if (this.closeCommand != null) {
            this.closeCommand.execute();
        }
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void resetDirty() {
    }

    public void setCloseCommand(Command command) {
        this.closeCommand = command;
    }
}

