/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.Popup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.DetailedSerializationException;

public class ErrorPopup
extends Popup {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private VerticalPanel body = new VerticalPanel();
    private static final String WIDTH = "400px";

    private ErrorPopup() {
        this.setTitle(this.constants.Error());
        this.setWidth(WIDTH);
        this.setModal(true);
        this.body.setWidth("100%");
    }

    @Override
    public Widget getContent() {
        return this.body;
    }

    private void addMessage(String message, String longMessage) {
        this.body.clear();
        if (message != null && message.contains("ItemExistsException")) {
            longMessage = message;
            message = this.constants.SorryAnItemOfThatNameAlreadyExistsInTheRepositoryPleaseChooseAnother();
        }
        final String longDescription = longMessage;
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new Image(images.validationError()));
        Label msg = new Label(message);
        msg.setStyleName("error-title");
        hp.add((Widget)msg);
        this.body.add((Widget)hp);
        final SimplePanel detailPanel = new SimplePanel();
        if (longMessage != null && !"".equals(longMessage)) {
            Button showD = new Button(this.constants.ShowDetail());
            showD.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    detailPanel.clear();
                    VerticalPanel vp = new VerticalPanel();
                    vp.add((Widget)new HTML("<hr/>"));
                    ScrollPanel longMessageLabel = new ScrollPanel((Widget)new Label(longDescription));
                    longMessageLabel.setWidth(ErrorPopup.WIDTH);
                    longMessageLabel.setStyleName("error-long-message");
                    vp.add((Widget)longMessageLabel);
                    detailPanel.add((Widget)vp);
                }
            });
            detailPanel.add((Widget)showD);
        }
        detailPanel.setWidth("100%");
        this.body.add((Widget)detailPanel);
        this.show();
    }

    public static void showMessage(String message) {
        ErrorPopup instance = new ErrorPopup();
        instance.addMessage(message, null);
        LoadingPopup.close();
    }

    public static void showMessage(DetailedSerializationException exception) {
        ErrorPopup instance = new ErrorPopup();
        instance.addMessage(exception.getMessage(), exception.getLongDescription());
        LoadingPopup.close();
    }
}

