/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.configurations;

import java.util.Map;

public class ApplicationPreferences {
    public static final String DATE_FORMAT = "drools.dateformat";
    public static final String DATE_TIME_FORMAT = "drools.datetimeformat";
    public static final String DEFAULT_LANGUAGE = "drools.defaultlanguage";
    public static final String DEFAULT_COUNTRY = "drools.defaultcountry";
    public static final String DESIGNER_URL = "designer.url";
    public static final String DESIGNER_CONTEXT = "designer.context";
    public static final String DESIGNER_PROFILE = "designer.profile";
    public static final String FORMBUILDER_URL = "formbuilder.url";
    public static final String FORMBUILDER_CONTEXT = "formbuilder.context";
    public static final String FORMBUILDER_PROFILE = "formbuilder.profile";
    public static final String GUVNOR_URL = "guvnor.url";
    public static final String SCORECARDS_ASSET = "asset.enabled.scorecards";
    public static final String GUVNOR_TESTSCENARIO_MAXRULEFIRINGS = "guvnor.testscenario.maxrulefirings";
    public static ApplicationPreferences instance;
    private Map<String, String> preferences;

    private ApplicationPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public static void setUp(Map<String, String> map) {
        instance = new ApplicationPreferences(map);
    }

    public static boolean getBooleanPref(String name) {
        return ApplicationPreferences.getBooleanPref(name, false);
    }

    public static boolean getBooleanPref(String name, boolean defaultValue) {
        if (ApplicationPreferences.instance.preferences.containsKey(name)) {
            return Boolean.parseBoolean(ApplicationPreferences.instance.preferences.get(name));
        }
        return defaultValue;
    }

    public static String getStringPref(String name) {
        return ApplicationPreferences.instance.preferences.get(name);
    }

    public static boolean enabledFormat(String format) {
        return ApplicationPreferences.getBooleanPref("asset.format.enabled." + format, true);
    }

    public static String getDroolsDateFormat() {
        return ApplicationPreferences.getStringPref(DATE_FORMAT);
    }

    public static String getDroolsDateTimeFormat() {
        return ApplicationPreferences.getStringPref(DATE_TIME_FORMAT);
    }

    public static boolean showVerifier() {
        return ApplicationPreferences.getBooleanPref("verifier");
    }

    public static boolean showVisualRuleFlow() {
        return ApplicationPreferences.getBooleanPref("visual-ruleflow");
    }

    public static String getDesignerURL() {
        return ApplicationPreferences.getStringPref(DESIGNER_URL);
    }

    public static String getDesignerContext() {
        return ApplicationPreferences.getStringPref(DESIGNER_CONTEXT);
    }

    public static String getDesignerProfile() {
        return ApplicationPreferences.getStringPref(DESIGNER_PROFILE);
    }

    public static String getFormBuilderURL() {
        return ApplicationPreferences.getStringPref(FORMBUILDER_URL);
    }

    public static String getFormBuilderContext() {
        return ApplicationPreferences.getStringPref(FORMBUILDER_CONTEXT);
    }

    public static String getFormBuilderProfile() {
        return ApplicationPreferences.getStringPref(FORMBUILDER_PROFILE);
    }

    public static String getGuvnorURL() {
        return ApplicationPreferences.getStringPref(GUVNOR_URL);
    }
}

