/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.ServerPushNotification;

public class PushClient {
    private static final PushClient INSTANCE = new PushClient();
    private List<ServerPushNotification> callbacks = new ArrayList<ServerPushNotification>();
    private boolean connected = false;

    public static PushClient instance() {
        return INSTANCE;
    }

    private PushClient() {
    }

    public void subscribe(ServerPushNotification pushed) {
        if (!this.connected) {
            this.connect();
        }
        this.callbacks.add(pushed);
    }

    private void connect() {
        this.connected = true;
        System.err.println("Connecting" + System.currentTimeMillis());
        Timer timer = new Timer(){

            public void run() {
                RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
                repositoryService.subscribe((AsyncCallback)new AsyncCallback<List<PushResponse>>(){

                    public void onFailure(Throwable caught) {
                        System.err.println("FAIL" + System.currentTimeMillis());
                    }

                    public void onSuccess(List<PushResponse> result) {
                        PushClient.this.processResult(result);
                    }
                });
            }
        };
        timer.scheduleRepeating(60000);
    }

    private void processResult(List<PushResponse> result) {
        if (result == null) {
            System.err.println("NULL result :(");
            return;
        }
        for (PushResponse msg : result) {
            System.err.println("Processing pushed message:" + msg.messageType + "," + msg.message);
            for (ServerPushNotification pn : this.callbacks) {
                System.err.println("performing callback...");
                pn.messageReceived(msg);
            }
        }
    }

    public void unsubscribe(ServerPushNotification pushed) {
        this.callbacks.remove(pushed);
    }
}

