/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.maven.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDownloadUtil {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtil.class);

    private FileDownloadUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String downloadURL, String fullPathToLocalFile) {
        OutputStream outStream = null;
        InputStream is = null;
        try {
            int byteRead = 0;
            URL url = new URL(downloadURL);
            URLConnection uCon = url.openConnection();
            is = uCon.getInputStream();
            outStream = new BufferedOutputStream(new FileOutputStream(fullPathToLocalFile));
            byte[] buf = new byte[1024];
            while ((byteRead = is.read(buf)) != -1) {
                outStream.write(buf, 0, byteRead);
            }
        }
        catch (Exception e) {
            File file = null;
            return file;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        File resultFile = new File(fullPathToLocalFile);
        if (!resultFile.exists()) {
            return null;
        }
        return resultFile;
    }
}

