/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.jboss.seam.security.annotations.permission.Identifier;
import org.jboss.seam.security.permission.IdentifierStrategy;
import org.jboss.seam.security.util.Strings;

public class EntityIdentifierStrategy
implements IdentifierStrategy {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();
    @Inject
    BeanManager manager;
    @Inject
    Instance<EntityManager> entityManagerInstance;

    public boolean canIdentify(Class<?> targetClass) {
        return targetClass.isAnnotationPresent(Entity.class);
    }

    public String getIdentifier(Object target) {
        return String.format("%s:%s", this.getIdentifierName(target.getClass()), null);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && !Strings.isEmpty((identifier = cls.getAnnotation(Identifier.class)).name())) {
                name = identifier.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }
}

