/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.rpc.SessionInfo;

@Service
public class DeleteServiceImpl
implements DeleteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;

    public void delete(Path path, String comment) {
        try {
            LOGGER.info("User:" + this.identity.getIdentifier() + " deleting file [" + path.getFileName() + "]");
            this.ioService.delete(Paths.convert((Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

