/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.GuidedDecisionTableOptions;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.GlobalAreaAssetSelector;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.explorer.RefreshSuggestionCompletionEngineEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.NewAssetConfiguration;
import org.drools.guvnor.client.rpc.NewAssetWithContentConfiguration;
import org.drools.guvnor.client.rpc.NewGuidedDecisionTableAssetConfiguration;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.widgets.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.widgets.drools.wizards.assets.NewGuidedDecisionTableAssetWizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardPlace;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;

public class NewAssetWizard
extends FormStylePopup {
    private TextBox name = new TextBox();
    private TextArea description = new TextArea();
    private GuidedDecisionTableOptions guidedDecisionTableOptions = new GuidedDecisionTableOptions();
    private String initialCategory;
    private ListBox formatChooser = this.getFormatChooser();
    private RadioButton createInPackageButton = new RadioButton("creatinpackagegroup", Constants.INSTANCE.CreateInPackage());
    private RadioButton createInGlobalButton = new RadioButton("creatinpackagegroup", Constants.INSTANCE.CreateInGlobalArea());
    private RulePackageSelector packageSelector = new RulePackageSelector();
    private RulePackageSelector importedPackageSelector = new RulePackageSelector();
    private GlobalAreaAssetSelector globalAreaAssetSelector;
    private String format;
    private final NewAssetFormStyleLayout newAssetLayout = new NewAssetFormStyleLayout();
    private final ImportAssetFormStyleLayout importAssetLayout = new ImportAssetFormStyleLayout();
    private final ClientFactory clientFactory;
    private final EventBus eventBus;
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);

    public NewAssetWizard(boolean showCategories, String format, ClientFactory clientFactory, EventBus eventBus) {
        super(DroolsGuvnorImages.INSTANCE.Wizard(), NewAssetWizard.getTitle(format, clientFactory));
        this.format = format;
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        RadioButton newPackage = new RadioButton("layoutgroup", Constants.INSTANCE.CreateNewAsset());
        newPackage.setValue(Boolean.valueOf(true));
        RadioButton importPackage = new RadioButton("layoutgroup", Constants.INSTANCE.CreateLinkedAsset());
        this.newAssetLayout.setVisible(true);
        this.createClickHandlerForNewPackageButton(newPackage);
        this.importAssetLayout.setVisible(false);
        this.createClickHandlerForImportPackageButton(importPackage);
        this.addAttribute("", (Widget)this.createVerticalPanelFor(newPackage, importPackage));
        this.addRow((Widget)this.newAssetLayout);
        this.addRow((Widget)this.importAssetLayout);
        this.newAssetLayout.addAttribute(Constants.INSTANCE.NameColon(), (Widget)this.name);
        this.setAfterShowCommand();
        if (showCategories) {
            this.newAssetLayout.addAttribute(Constants.INSTANCE.InitialCategory(), this.getCatChooser());
        }
        this.handleLayoutForFormat(format);
        this.createInPackageButton.setValue(Boolean.valueOf(true));
        this.newAssetLayout.buildNewAssetFormStyleLayout();
        this.globalAreaAssetSelector = new GlobalAreaAssetSelector(format);
        this.importAssetLayout.buildImportAssetLayout();
    }

    private static String getTitle(String format, ClientFactory cf) {
        if (format == null) {
            return Constants.INSTANCE.NewRule();
        }
        String title = cf.getAssetEditorFactory().getAssetEditorTitle(format);
        return Constants.INSTANCE.New() + " " + title;
    }

    private Button createOkButtonAndClickHandler() {
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewAssetWizard.this.ok();
            }
        });
        return ok;
    }

    private HorizontalPanel createHorizontalePanelFor() {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)this.createInPackageButton);
        hp.add((Widget)this.packageSelector);
        return hp;
    }

    private void handleLayoutForFormat(String format) {
        if (format == null) {
            this.newAssetLayout.addAttribute(Constants.INSTANCE.TypeFormatOfRule(), (Widget)this.formatChooser);
            final int useWizardRowIndex = this.newAssetLayout.addAttribute(Constants.INSTANCE.NewAssetWizardGuidedDecisionTableOptions(), (Widget)this.guidedDecisionTableOptions);
            this.newAssetLayout.setAttributeVisibility(useWizardRowIndex, false);
            this.formatChooser.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    boolean isVisible = false;
                    int selectedIndex = NewAssetWizard.this.formatChooser.getSelectedIndex();
                    if (selectedIndex >= 0) {
                        String value = NewAssetWizard.this.formatChooser.getValue(selectedIndex);
                        isVisible = "gdst".equals(value);
                    }
                    NewAssetWizard.this.newAssetLayout.setAttributeVisibility(useWizardRowIndex, isVisible);
                }
            });
        } else if ("".equals(format)) {
            final TextBox fmt = new TextBox();
            this.newAssetLayout.addAttribute(Constants.INSTANCE.FileExtensionTypeFormat(), (Widget)fmt);
            fmt.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    NewAssetWizard.this.format = fmt.getText();
                }
            });
        }
    }

    private void setAfterShowCommand() {
        this.setAfterShow(new Command(){

            public void execute() {
                NewAssetWizard.this.name.setFocus(true);
            }
        });
    }

    private VerticalPanel createVerticalPanelFor(RadioButton newPackage, RadioButton importPackage) {
        VerticalPanel ab = new VerticalPanel();
        ab.add((Widget)newPackage);
        ab.add((Widget)importPackage);
        return ab;
    }

    private void createClickHandlerForImportPackageButton(RadioButton importPackage) {
        importPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewAssetWizard.this.newAssetLayout.setVisible(false);
                NewAssetWizard.this.importAssetLayout.setVisible(true);
            }
        });
    }

    private void createClickHandlerForNewPackageButton(RadioButton newPackage) {
        newPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewAssetWizard.this.newAssetLayout.setVisible(true);
                NewAssetWizard.this.importAssetLayout.setVisible(false);
            }
        });
    }

    private Widget getCatChooser() {
        CategoryExplorerWidget w = new CategoryExplorerWidget(new CategorySelectHandler(){

            public void selected(String selectedPath) {
                NewAssetWizard.this.initialCategory = selectedPath;
            }
        });
        ScrollPanel scroll = new ScrollPanel((Widget)w);
        scroll.setAlwaysShowScrollBars(true);
        scroll.setSize("300px", "130px");
        return scroll;
    }

    private ListBox getFormatChooser() {
        ListBox box = new ListBox();
        box.addItem(Constants.INSTANCE.BusinessRuleGuidedEditor(), "brl");
        box.addItem(Constants.INSTANCE.DSLBusinessRuleTextEditor(), "dslr");
        box.addItem(Constants.INSTANCE.DRLRuleTechnicalRuleTextEditor(), "drl");
        box.addItem(Constants.INSTANCE.DecisionTableSpreadsheet(), "xls");
        box.addItem(Constants.INSTANCE.DecisionTableWebGuidedEditor(), "gdst");
        if (ApplicationPreferences.getBooleanPref((String)"asset.enabled.scorecards")) {
            box.addItem(Constants.INSTANCE.ScorecardSpreadsheet(), "scxls");
            box.addItem(Constants.INSTANCE.ScorecardWebGuidedEditor(), "scgd");
        }
        box.setSelectedIndex(0);
        return box;
    }

    void ok() {
        String assetFormat = this.getFormat();
        if ("".equals(assetFormat)) {
            Window.alert((String)Constants.INSTANCE.PleaseEnterAFormatFileType());
            return;
        }
        String assetName = this.name.getText();
        if ("".equals(assetName)) {
            Window.alert((String)Constants.INSTANCE.InvalidModelName(assetName));
            return;
        }
        String packageName = this.createInGlobalButton.getValue() != false ? "globalArea" : this.packageSelector.getSelectedPackage();
        Command cmd = null;
        cmd = assetFormat.equals("gdst") ? (this.guidedDecisionTableOptions.isUsingWizard() ? this.makeGuidedDecisionTableWizardSaveCommand(assetName, packageName, this.packageSelector.getSelectedPackageUUID(), this.description.getText(), this.initialCategory, assetFormat) : this.makeGuidedDecisionTableSaveCommand(assetName, packageName, this.packageSelector.getSelectedPackageUUID(), this.description.getText(), this.initialCategory, assetFormat)) : this.makeGeneralAssetSaveCommand(assetName, packageName, this.packageSelector.getSelectedPackageUUID(), this.description.getText(), this.initialCategory, assetFormat);
        cmd.execute();
    }

    private Command makeGuidedDecisionTableWizardSaveCommand(final String assetName, final String packageName, final String packageUUID, final String description, final String initialCategory, final String format) {
        final Command cmdInvokeWizard = new Command(){

            public void execute() {
                GuidedDecisionTable52 content = new GuidedDecisionTable52();
                content.setTableFormat(NewAssetWizard.this.guidedDecisionTableOptions.getTableFormat());
                NewGuidedDecisionTableAssetConfiguration config = new NewGuidedDecisionTableAssetConfiguration(assetName, packageName, packageUUID, description, initialCategory, format, content);
                NewGuidedDecisionTableAssetWizardContext context = new NewGuidedDecisionTableAssetWizardContext(config);
                NewAssetWizard.this.clientFactory.getPlaceController().goTo((Place)new WizardPlace((WizardContext)context));
            }
        };
        Command cmdCheckBeforeInvokingWizard = new Command(){

            public void execute() {
                LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
                NewAssetWizard.this.repositoryService.doesAssetExistInModule(assetName, packageName, (AsyncCallback)NewAssetWizard.this.createGenericCallBackForCheckingIfExists(cmdInvokeWizard));
            }
        };
        return cmdCheckBeforeInvokingWizard;
    }

    private Command makeGuidedDecisionTableSaveCommand(String assetName, String packageName, String packageUUID, String description, String initialCategory, String format) {
        GuidedDecisionTable52 content = new GuidedDecisionTable52();
        content.setTableFormat(this.guidedDecisionTableOptions.getTableFormat());
        final NewGuidedDecisionTableAssetConfiguration config = new NewGuidedDecisionTableAssetConfiguration(assetName, packageName, packageUUID, description, initialCategory, format, content);
        final Command cmdSave = new Command(){

            public void execute() {
                NewAssetWizard.this.repositoryService.createNewRule((NewAssetWithContentConfiguration)config, (AsyncCallback)NewAssetWizard.this.createGenericCallbackForOk());
            }
        };
        Command cmdCheckBeforeSaving = new Command(){

            public void execute() {
                LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
                NewAssetWizard.this.repositoryService.doesAssetExistInModule(config.getAssetName(), config.getPackageName(), (AsyncCallback)NewAssetWizard.this.createGenericCallBackForCheckingIfExists(cmdSave));
            }
        };
        return cmdCheckBeforeSaving;
    }

    private Command makeGeneralAssetSaveCommand(String assetName, String packageName, String packageUUID, String description, String initialCategory, String format) {
        final NewAssetConfiguration config = new NewAssetConfiguration(assetName, packageName, packageUUID, description, initialCategory, format);
        final Command cmdSave = new Command(){

            public void execute() {
                NewAssetWizard.this.repositoryService.createNewRule(config, (AsyncCallback)NewAssetWizard.this.createGenericCallbackForOk());
            }
        };
        Command cmdCheckBeforeSaving = new Command(){

            public void execute() {
                LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
                NewAssetWizard.this.repositoryService.doesAssetExistInModule(config.getAssetName(), config.getPackageName(), (AsyncCallback)NewAssetWizard.this.createGenericCallBackForCheckingIfExists(cmdSave));
            }
        };
        return cmdCheckBeforeSaving;
    }

    void importOK() {
        LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
        this.repositoryService.createNewImportedRule(this.globalAreaAssetSelector.getSelectedAsset(), this.importedPackageSelector.getSelectedPackage(), this.createGenericCallbackForImportOk());
    }

    private GenericCallback<String> createGenericCallbackForOk() {
        GenericCallback<String> cb = new GenericCallback<String>(){

            public void onSuccess(String uuid) {
                LoadingPopup.close();
                if (uuid.startsWith("DUPLICATE")) {
                    Window.alert((String)Constants.INSTANCE.AssetNameAlreadyExistsPickAnother());
                } else {
                    NewAssetWizard.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(NewAssetWizard.this.packageSelector.getSelectedPackageUUID()));
                    NewAssetWizard.this.openEditor(uuid);
                    NewAssetWizard.this.hide();
                }
            }
        };
        return cb;
    }

    private GenericCallback<String> createGenericCallbackForImportOk() {
        GenericCallback<String> cb = new GenericCallback<String>(){

            public void onSuccess(String uuid) {
                if (uuid.startsWith("DUPLICATE")) {
                    LoadingPopup.close();
                    Window.alert((String)Constants.INSTANCE.AssetNameAlreadyExistsPickAnother());
                } else {
                    NewAssetWizard.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(NewAssetWizard.this.importedPackageSelector.getSelectedPackageUUID()));
                    NewAssetWizard.this.flushSuggestionCompletionCache();
                    NewAssetWizard.this.openEditor(uuid);
                    NewAssetWizard.this.hide();
                }
            }
        };
        return cb;
    }

    private GenericCallback<Boolean> createGenericCallBackForCheckingIfExists(final Command cmd) {
        GenericCallback<Boolean> cb = new GenericCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                LoadingPopup.close();
                if (result.booleanValue()) {
                    Window.alert((String)Constants.INSTANCE.AssetNameAlreadyExistsPickAnother());
                } else {
                    NewAssetWizard.this.hide();
                    cmd.execute();
                }
            }
        };
        return cb;
    }

    public void flushSuggestionCompletionCache() {
        if (AssetFormats.isPackageDependency((String)this.format)) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.RefreshingContentAssistance());
            SuggestionCompletionCache.getInstance().loadPackage(this.importedPackageSelector.getSelectedPackage(), new Command(){

                public void execute() {
                    NewAssetWizard.this.eventBus.fireEvent((GwtEvent)new RefreshSuggestionCompletionEngineEvent(NewAssetWizard.this.importedPackageSelector.getSelectedPackage()));
                    LoadingPopup.close();
                }
            });
        }
    }

    private String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        return this.formatChooser.getValue(this.formatChooser.getSelectedIndex());
    }

    protected void openEditor(String uuid) {
        this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(uuid));
    }

    private class NewAssetFormStyleLayout
    extends FormStyleLayout {
        private NewAssetFormStyleLayout() {
        }

        protected void buildNewAssetFormStyleLayout() {
            this.addAttribute("", (Widget)NewAssetWizard.this.createHorizontalePanelFor());
            this.addAttribute("", (Widget)NewAssetWizard.this.createInGlobalButton);
            this.buildDescriptionTextArea(NewAssetWizard.this.format);
            this.addAttribute(Constants.INSTANCE.InitialDescription(), (Widget)NewAssetWizard.this.description);
            this.addAttribute("", (Widget)NewAssetWizard.this.createOkButtonAndClickHandler());
        }

        private void buildDescriptionTextArea(String format) {
            NewAssetWizard.this.description.setVisibleLines(4);
            NewAssetWizard.this.description.setWidth("100%");
            if ("dslr".equals(format)) {
                NewAssetWizard.this.description.setText(Constants.INSTANCE.DSLMappingTip());
            } else if ("enumeration".equals(format)) {
                NewAssetWizard.this.description.setText(Constants.INSTANCE.NewEnumDoco());
            } else if ("springContext".equals(format)) {
                NewAssetWizard.this.description.setText(Constants.INSTANCE.DescSpringContext());
            } else if ("serviceConfig".equals(format)) {
                NewAssetWizard.this.description.setText(Constants.INSTANCE.DescServiceConfig());
            } else if ("wid".equals(format)) {
                NewAssetWizard.this.description.setText(Constants.INSTANCE.DeskWorkItemDefinition());
            }
        }
    }

    private class ImportAssetFormStyleLayout
    extends FormStyleLayout {
        private ImportAssetFormStyleLayout() {
        }

        protected void buildImportAssetLayout() {
            this.addAttribute(Constants.INSTANCE.AssetToImport(), (Widget)NewAssetWizard.this.globalAreaAssetSelector);
            this.addAttribute(Constants.INSTANCE.Package() + ":", (Widget)NewAssetWizard.this.importedPackageSelector);
            this.addAttribute("", (Widget)this.createLinkedAssetOkButtonAndClickHandler());
            this.addRow((Widget)new HTML("<br/><b>" + Constants.INSTANCE.NoteNewLinkedAsset() + "</b>"));
            this.addRow((Widget)new HTML(Constants.INSTANCE.NewLinkedAssetDesc1()));
        }

        private Button createLinkedAssetOkButtonAndClickHandler() {
            Button linkedAssetOKButton = new Button(Constants.INSTANCE.OK());
            linkedAssetOKButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    NewAssetWizard.this.importOK();
                }
            });
            return linkedAssetOKButton;
        }
    }
}

