/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.messages.Constants;

public class ModelNameHelper {
    private static Map<String, String> TYPE_DESCRIPTIONS = new HashMap<String, String>(){
        private static final long serialVersionUID = 510L;
        {
            this.put("Integer", Constants.INSTANCE.WholeNumberInteger());
            this.put("Boolean", Constants.INSTANCE.TrueOrFalse());
            this.put("String", Constants.INSTANCE.Text());
            this.put("java.util.Date", Constants.INSTANCE.Date());
            this.put("java.math.BigDecimal", Constants.INSTANCE.DecimalNumber());
        }
    };

    public String getDesc(FieldMetaModel fieldMetaModel) {
        if (TYPE_DESCRIPTIONS.containsKey(fieldMetaModel.type)) {
            return TYPE_DESCRIPTIONS.get(fieldMetaModel.type);
        }
        return fieldMetaModel.type;
    }

    public Map<String, String> getTypeDescriptions() {
        return TYPE_DESCRIPTIONS;
    }

    public boolean isUniqueName(String type) {
        return !this.getTypeDescriptions().containsKey(type);
    }

    public void changeNameInModelNameHelper(String oldName, String newName) {
        this.getTypeDescriptions().remove(oldName);
        this.getTypeDescriptions().put(newName, newName);
    }

    public String getUserFriendlyTypeName(String systemTypeName) {
        String userFriendlyName;
        if (systemTypeName.contains(".")) {
            systemTypeName = systemTypeName.substring(systemTypeName.lastIndexOf(".") + 1);
        }
        if ((userFriendlyName = this.getTypeDescriptions().get(systemTypeName)) == null) {
            return systemTypeName;
        }
        return userFriendlyName;
    }
}

