/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.AbstractRuleModellerSelectorPopup;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class RuleModellerActionSelectorPopup
extends AbstractRuleModellerSelectorPopup {
    public RuleModellerActionSelectorPopup(RuleModel model, RuleModeller ruleModeller, String packageName, Integer position) {
        super(model, ruleModeller, packageName, position);
    }

    @Override
    protected String getPopupTitle() {
        return Constants.INSTANCE.AddANewAction();
    }

    public Widget getContent() {
        if (this.position == null) {
            this.positionCbo.addItem(Constants.INSTANCE.Bottom(), String.valueOf(this.model.rhs.length));
            this.positionCbo.addItem(Constants.INSTANCE.Top(), "0");
            for (int i = 1; i < this.model.rhs.length; ++i) {
                this.positionCbo.addItem(Constants.INSTANCE.Line0(i), String.valueOf(i));
            }
        } else {
            this.positionCbo.addItem(String.valueOf(this.position));
            this.positionCbo.setSelectedIndex(0);
        }
        if (this.completions.getDSLConditions().length == 0 && this.completions.getFactTypes().length == 0) {
            this.layoutPanel.addRow((Widget)new HTML("<div class='highlight'>" + Constants.INSTANCE.NoModelTip() + "</div>"));
        }
        if (this.position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(Constants.INSTANCE.PositionColon()));
            hp0.add((Widget)this.positionCbo);
            hp0.add((Widget)new InfoPopup(Constants.INSTANCE.PositionColon(), Constants.INSTANCE.ActionPositionExplanation()));
            this.layoutPanel.addRow((Widget)hp0);
        }
        this.choices = this.makeChoicesListBox();
        this.choicesPanel.add((Widget)this.choices);
        this.layoutPanel.addRow((Widget)this.choicesPanel);
        HorizontalPanel hp = new HorizontalPanel();
        Button ok = new Button(Constants.INSTANCE.OK());
        hp.add((Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuleModellerActionSelectorPopup.this.selectSomething();
            }
        });
        Button cancel = new Button(Constants.INSTANCE.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuleModellerActionSelectorPopup.this.hide();
            }
        });
        CheckBox chkOnlyDisplayDSLConditions = new CheckBox();
        chkOnlyDisplayDSLConditions.setText(Constants.INSTANCE.OnlyDisplayDSLActions());
        chkOnlyDisplayDSLConditions.setValue(Boolean.valueOf(this.bOnlyShowDSLConditions));
        chkOnlyDisplayDSLConditions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RuleModellerActionSelectorPopup.this.bOnlyShowDSLConditions = (Boolean)event.getValue();
                RuleModellerActionSelectorPopup.this.choicesPanel.setWidget((Widget)RuleModellerActionSelectorPopup.this.makeChoicesListBox());
            }
        });
        this.layoutPanel.addRow((Widget)chkOnlyDisplayDSLConditions);
        this.layoutPanel.addRow((Widget)hp);
        this.setAfterShow(new Command(){

            public void execute() {
                RuleModellerActionSelectorPopup.this.choices.setFocus(true);
            }
        });
        return this.layoutPanel;
    }

    private ListBox makeChoicesListBox() {
        this.choices = new ListBox(true);
        this.choices.setPixelSize(this.getChoicesWidth(), this.getChoicesHeight());
        this.choices.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    RuleModellerActionSelectorPopup.this.selectSomething();
                }
            }
        });
        this.addDSLSentences();
        if (!this.bOnlyShowDSLConditions) {
            this.addUpdateNotModify();
            this.addGlobals();
            this.addRetractions();
            this.addModifies();
            this.addInsertions();
            this.addLogicalInsertions();
            this.addGlobalCollections();
            this.addFreeFormDRL();
        }
        return this.choices;
    }

    private void addDSLSentences() {
        if (this.completions.getDSLActions().length > 0) {
            for (int i = 0; i < this.completions.getDSLActions().length; ++i) {
                final DSLSentence sen = this.completions.getDSLActions()[i];
                if (sen == null) continue;
                String sentence = sen.toString();
                this.choices.addItem(sentence, "DSL" + sentence);
                this.cmds.put("DSL" + sentence, new Command(){

                    public void execute() {
                        RuleModellerActionSelectorPopup.this.addNewDSLRhs(sen, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addUpdateNotModify() {
        List vars = this.model.getAllLHSVariables();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(Constants.INSTANCE.ChangeFieldValuesOf0(v), "VAR" + v);
            this.cmds.put("VAR" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addActionSetField(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addGlobals() {
        String[] globals = this.completions.getGlobalVariables();
        if (globals.length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < globals.length; ++i) {
            final String v = globals[i];
            this.choices.addItem(Constants.INSTANCE.ChangeFieldValuesOf0(v), "GLOBVAR" + v);
            this.cmds.put("GLOBVAR" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addActionSetField(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addRetractions() {
        List vars = this.model.getLHSBoundFacts();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(Constants.INSTANCE.Retract0(v), "RET" + v);
            this.cmds.put("RET" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addRetract(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addModifies() {
        List vars = this.model.getAllLHSVariables();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(Constants.INSTANCE.Modify0(v), "MOD" + v);
            this.cmds.put("MOD" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addModify(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addInsertions() {
        if (this.completions.getFactTypes().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < this.completions.getFactTypes().length; ++i) {
            final String item = this.completions.getFactTypes()[i];
            this.choices.addItem(Constants.INSTANCE.InsertFact0(item), "INS" + item);
            this.cmds.put("INS" + item, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new ActionInsertFact(item), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addLogicalInsertions() {
        if (this.completions.getFactTypes().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < this.completions.getFactTypes().length; ++i) {
            final String item = this.completions.getFactTypes()[i];
            this.choices.addItem(Constants.INSTANCE.LogicallyInsertFact0(item), "LINS" + item);
            this.cmds.put("LINS" + item, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new ActionInsertLogicalFact(item), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addGlobalCollections() {
        List vars = this.model.getLHSBoundFacts();
        if (vars.size() == 0) {
            return;
        }
        if (this.completions.getGlobalCollections().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (String bf : vars) {
            for (int i = 0; i < this.completions.getGlobalCollections().length; ++i) {
                final String glob = this.completions.getGlobalCollections()[i];
                final String var = bf;
                this.choices.addItem(Constants.INSTANCE.Append0ToList1(var, glob), "GLOBCOL" + glob + var);
                this.cmds.put("GLOBCOL" + glob + var, new Command(){

                    public void execute() {
                        ActionGlobalCollectionAdd gca = new ActionGlobalCollectionAdd();
                        gca.globalName = glob;
                        gca.factName = var;
                        RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)gca, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addFreeFormDRL() {
        List lhsVars = this.model.getAllLHSVariables();
        List rhsVars = this.model.getRHSBoundFacts();
        String[] globals = this.completions.getGlobalVariables();
        if (UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_KNOWLEDGE_BASES_VIEW})) {
            this.choices.addItem("..................");
            this.choices.addItem(Constants.INSTANCE.AddFreeFormDrl(), "FF");
            this.cmds.put("FF", new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new FreeFormLine(), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
            if (globals.length > 0) {
                this.choices.addItem("..................");
            }
            for (int i = 0; i < globals.length; ++i) {
                final String v = globals[i];
                this.choices.addItem(Constants.INSTANCE.CallMethodOn0(v), "GLOBCALL" + v);
                this.cmds.put("GLOBCALL" + v, new Command(){

                    public void execute() {
                        RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
            if (lhsVars.size() > 0) {
                this.choices.addItem("..................");
            }
            for (final String v : lhsVars) {
                this.choices.addItem(Constants.INSTANCE.CallMethodOn0(v), "CALL" + v);
                this.cmds.put("CALL" + v, new Command(){

                    public void execute() {
                        RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
            if (rhsVars.size() > 0) {
                this.choices.addItem("..................");
            }
            for (final String v : rhsVars) {
                this.choices.addItem(Constants.INSTANCE.CallMethodOn0(v), "CALL" + v);
                this.cmds.put("CALL" + v, new Command(){

                    public void execute() {
                        RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addNewDSLRhs(DSLSentence sentence, int position) {
        this.model.addRhsItem((IAction)sentence.copy(), position);
    }

    private void addRetract(String var, int position) {
        this.model.addRhsItem((IAction)new ActionRetractFact(var), position);
    }

    private void addActionSetField(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionSetField(itemText), position);
    }

    private void addCallMethod(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionCallMethod(itemText), position);
    }

    private void addModify(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionUpdateField(itemText), position);
    }
}

