/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.GenericColumnCommand;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;

public class ActionInsertFactPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;
    private final DTCellValueWidgetFactory factory;
    private final BRLRuleModel validator;
    private final DTCellValueUtilities utilities;
    private ActionInsertFactCol52 editingCol;
    private final boolean isReadOnly;

    public ActionInsertFactPopup(SuggestionCompletionEngine sce, final GuidedDecisionTable52 model, final GenericColumnCommand refreshGrid, final ActionInsertFactCol52 col, final boolean isNew, boolean isReadOnly) {
        this.validator = new BRLRuleModel(model);
        this.editingCol = this.cloneActionInsertColumn(col);
        this.model = model;
        this.sce = sce;
        this.isReadOnly = isReadOnly;
        this.utilities = new DTCellValueUtilities(model, sce);
        this.factory = DTCellValueWidgetFactory.getInstance(model, sce, isReadOnly, this.allowEmptyValues());
        this.setTitle(Constants.INSTANCE.ActionColumnConfigurationInsertingANewFact());
        this.setModal(false);
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = this.createChangePatternButton();
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(Constants.INSTANCE.Pattern(), (Widget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = this.createEditFieldButton();
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(Constants.INSTANCE.Field(), (Widget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionInsertFactPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (Widget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ActionInsertFactPopup.this.editingCol.setValueList(ActionInsertFactPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ActionInsertFactPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(model.getValueList((BaseColumn)ActionInsertFactPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ActionInsertFactPopup.this.utilities.asString(ActionInsertFactPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ActionInsertFactPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ActionInsertFactPopup.this.editingCol.getDefaultValue();
                            DTDataTypes52 dataType = ActionInsertFactPopup.this.utilities.getDataType((BaseColumn)ActionInsertFactPopup.this.editingCol);
                            ActionInsertFactPopup.this.utilities.assertDTCellValue(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((Widget)new InfoPopup(Constants.INSTANCE.ValueList(), Constants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(Constants.INSTANCE.optionalValueList(), (Widget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(Constants.INSTANCE.DefaultValue(), (Widget)this.defaultValueWidgetContainer);
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(Constants.INSTANCE.LimitedEntryValue(), (Widget)this.limitedEntryValueWidgetContainer);
            this.makeLimitedValueWidget();
        }
        this.addAttribute(Constants.INSTANCE.LogicallyInsertColon(), this.doInsertLogical());
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (Widget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!ActionInsertFactPopup.this.isValidFactType()) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnPattern());
                    return;
                }
                if (!ActionInsertFactPopup.this.isValidFactField()) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnField());
                    return;
                }
                if (null == ActionInsertFactPopup.this.editingCol.getHeader() || "".equals(ActionInsertFactPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
                    return;
                }
                if (isNew) {
                    if (!ActionInsertFactPopup.this.unique(ActionInsertFactPopup.this.editingCol.getHeader())) {
                        Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                        return;
                    }
                } else if (!col.getHeader().equals(ActionInsertFactPopup.this.editingCol.getHeader()) && !ActionInsertFactPopup.this.unique(ActionInsertFactPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                    return;
                }
                refreshGrid.execute((DTColumnConfig52)ActionInsertFactPopup.this.editingCol);
                ActionInsertFactPopup.this.hide();
            }
        });
        this.addAttribute("", (Widget)apply);
    }

    private ImageButton createEditFieldButton() {
        Image edit = GuvnorImages.INSTANCE.Edit();
        edit.setAltText(Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        Image editDisabled = DroolsGuvnorImages.INSTANCE.EditDisabled();
        editDisabled.setAltText(Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        return new ImageButton(edit, editDisabled, Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionInsertFactPopup.this.showFieldChange();
            }
        });
    }

    private ImageButton createChangePatternButton() {
        Image edit = GuvnorImages.INSTANCE.Edit();
        edit.setAltText(Constants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        Image editDisabled = DroolsGuvnorImages.INSTANCE.EditDisabled();
        editDisabled.setAltText(Constants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        return new ImageButton(edit, editDisabled, Constants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionInsertFactPopup.this.showChangePattern(w);
            }
        });
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ActionInsertFactCol52 cloneActionInsertColumn(ActionInsertFactCol52 col) {
        LimitedEntryActionInsertFactCol52 clone = null;
        if (col instanceof LimitedEntryActionInsertFactCol52) {
            clone = new LimitedEntryActionInsertFactCol52();
            DTCellValue52 dcv = this.cloneLimitedEntryValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionInsertFactCol52();
        }
        clone.setBoundName(col.getBoundName());
        clone.setType(col.getType());
        clone.setFactField(col.getFactField());
        clone.setFactType(col.getFactType());
        clone.setHeader(col.getHeader());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(new DTCellValue52(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setInsertLogical(col.isInsertLogical());
        return clone;
    }

    private DTCellValue52 cloneLimitedEntryValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryActionInsertFactCol52)) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            return;
        }
        LimitedEntryActionInsertFactCol52 lea = (LimitedEntryActionInsertFactCol52)this.editingCol;
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lea.getValue() == null) {
            lea.setValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.editingCol, lea.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DTDataTypes52 dataType = this.utilities.getDataType((BaseColumn)this.editingCol);
        this.utilities.assertDTCellValue(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.editingCol, defaultValue));
    }

    private void doFieldLabel() {
        if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseChooseFactType());
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doPatternLabel() {
        if (this.editingCol.getFactType() != null) {
            this.patternLabel.setText(this.editingCol.getFactType() + " [" + this.editingCol.getBoundName() + "]");
        }
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingCol.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = !this.sce.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionInsertFactPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (ActionCol52 o : this.model.getActionCols()) {
            ActionInsertFactCol52 c;
            ActionCol52 col = o;
            if (!(col instanceof ActionInsertFactCol52) || vars.contains((c = (ActionInsertFactCol52)col).getBoundName())) continue;
            patterns.addItem(c.getFactType() + " [" + c.getBoundName() + "]", c.getFactType() + " " + c.getBoundName());
            vars.add(c.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, this.editingCol.getFactType());
        final ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute(Constants.INSTANCE.Field(), (Widget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionInsertFactPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionInsertFactPopup.this.editingCol.setType(ActionInsertFactPopup.this.sce.getFieldType(ActionInsertFactPopup.this.editingCol.getFactType(), ActionInsertFactPopup.this.editingCol.getFactField()));
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doValueList();
                ActionInsertFactPopup.this.doFieldLabel();
                pop.hide();
            }
        });
        pop.show();
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        final ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        final FormStylePopup pop = new FormStylePopup();
        Button ok = new Button("OK");
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(Constants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (Widget)hp);
        pop.addAttribute("", (Widget)new HTML(Constants.INSTANCE.ORwithEmphasis()));
        Button createPattern = new Button(Constants.INSTANCE.CreateNewFactPattern());
        createPattern.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                pop.hide();
                ActionInsertFactPopup.this.showNewPatternDialog();
            }
        });
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
                ActionInsertFactPopup.this.editingCol.setFactType(val[0]);
                ActionInsertFactPopup.this.editingCol.setBoundName(val[1]);
                ActionInsertFactPopup.this.editingCol.setFactField(null);
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doPatternLabel();
                ActionInsertFactPopup.this.doFieldLabel();
                ActionInsertFactPopup.this.doValueList();
                pop.hide();
            }
        });
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.NewFactSelectTheType());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.sce.getFactTypes().length; ++i) {
            types.addItem(this.sce.getFactTypes()[i]);
        }
        pop.addAttribute(Constants.INSTANCE.FactType(), (Widget)types);
        BindingTextBox binding = new BindingTextBox();
        pop.addAttribute(Constants.INSTANCE.Binding(), (Widget)binding);
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void onClick(ClickEvent w) {
                String ft = types.getItemText(types.getSelectedIndex());
                String fn = this.val$binding.getText();
                if (fn.equals("")) {
                    Window.alert((String)Constants.INSTANCE.PleaseEnterANameForFact());
                    return;
                }
                if (fn.equals(ft)) {
                    Window.alert((String)Constants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                    return;
                }
                if (!ActionInsertFactPopup.this.isBindingUnique(fn)) {
                    Window.alert((String)Constants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                    return;
                }
                ActionInsertFactPopup.this.editingCol.setBoundName(this.val$binding.getText());
                ActionInsertFactPopup.this.editingCol.setFactType(types.getItemText(types.getSelectedIndex()));
                ActionInsertFactPopup.this.editingCol.setFactField(null);
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doPatternLabel();
                ActionInsertFactPopup.this.doFieldLabel();
                ActionInsertFactPopup.this.doValueList();
                this.val$pop.hide();
            }
        });
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private boolean isBindingUnique(String binding) {
        return !this.validator.isVariableNameUsed(binding);
    }

    private boolean isValidFactType() {
        return this.editingCol.getFactType() != null && !"".equals(this.editingCol.getFactType());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private Widget doInsertLogical() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isInsertLogical()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionInsertFactPopup.this.sce.isGlobalVariable(ActionInsertFactPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionInsertFactPopup.this.editingCol.setInsertLogical(false);
                    } else {
                        ActionInsertFactPopup.this.editingCol.setInsertLogical(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((Widget)new InfoPopup(Constants.INSTANCE.LogicallyInsertANewFact(), Constants.INSTANCE.LogicallyAssertAFactTheFactWillBeRetractedWhenTheSupportingEvidenceIsRemoved()));
        return hp;
    }
}

