/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.NumericShortTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericShortEditCell
extends AbstractPopupEditCell<Short, Short> {
    private final TextBox textBox = new NumericShortTextBox();

    public PopupNumericShortEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupNumericShortEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, Short value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toString()));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        Short number = null;
        if (text.length() > 0) {
            try {
                number = new Short(text);
            }
            catch (NumberFormatException e) {
                number = new Short("0");
            }
        }
        this.setValue(this.lastContext, this.lastParent, number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, Short value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toString()));
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupNumericShortEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupNumericShortEditCell.this.offsetX, parent.getAbsoluteTop() + PopupNumericShortEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupNumericShortEditCell.this.textBox.getValue();
                        PopupNumericShortEditCell.this.textBox.setFocus(true);
                        PopupNumericShortEditCell.this.textBox.setCursorPos(text.length());
                        PopupNumericShortEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

