/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FiredRulesPanel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;

public class ExecutionWidget
extends Composite {
    private final ExecutionTrace executionTrace;

    public ExecutionWidget(final ExecutionTrace executionTrace, boolean showResults) {
        this.executionTrace = executionTrace;
        final HorizontalPanel simulDatePanel = this.simulDate();
        simulDatePanel.setVisible(this.isScenarioSimulatedDateSet());
        final ListBox choice = new ListBox();
        choice.addItem(Constants.INSTANCE.UseRealDateAndTime());
        choice.addItem(Constants.INSTANCE.UseASimulatedDateAndTime());
        choice.setSelectedIndex(executionTrace.getScenarioSimulatedDate() == null ? 0 : 1);
        choice.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (choice.getSelectedIndex() == 0) {
                    simulDatePanel.setVisible(false);
                    executionTrace.setScenarioSimulatedDate(null);
                } else {
                    simulDatePanel.setVisible(true);
                }
            }
        });
        HorizontalPanel layout = new HorizontalPanel();
        layout.add((Widget)new Image(DroolsGuvnorImageResources.INSTANCE.executionTrace()));
        layout.add((Widget)choice);
        layout.add((Widget)simulDatePanel);
        if (showResults && this.isResultNotNullAndHaveRulesFired()) {
            VerticalPanel replacingLayout = new VerticalPanel();
            replacingLayout.add((Widget)new FiredRulesPanel(executionTrace));
            replacingLayout.add((Widget)layout);
            this.initWidget((Widget)replacingLayout);
        } else {
            this.initWidget((Widget)layout);
        }
    }

    private boolean isResultNotNullAndHaveRulesFired() {
        return this.executionTrace.getExecutionTimeResult() != null && this.executionTrace.getNumberOfRulesFired() != null;
    }

    private boolean isScenarioSimulatedDateSet() {
        return this.executionTrace.getScenarioSimulatedDate() != null;
    }

    private HorizontalPanel simulDate() {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        String format = "yyyy-MM-dd HH:mm";
        final TextBox textBox = new TextBox();
        if (this.executionTrace.getScenarioSimulatedDate() == null) {
            textBox.setText("<yyyy-MM-dd HH:mm>");
        } else {
            textBox.setText(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(this.executionTrace.getScenarioSimulatedDate()));
        }
        final SmallLabel dateHint = new SmallLabel();
        textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                try {
                    String exampleDate = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(new Date());
                    String suggestedDate = textBox.getText() + exampleDate.substring(textBox.getText().length());
                    Date d = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).parse(suggestedDate);
                    dateHint.setText(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(d));
                }
                catch (Exception e) {
                    dateHint.setText("...");
                }
            }
        });
        textBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (textBox.getText().trim().equals("")) {
                    textBox.setText(Constants.INSTANCE.currentDateAndTime());
                } else {
                    try {
                        Date d = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).parse(textBox.getText());
                        ExecutionWidget.this.executionTrace.setScenarioSimulatedDate(d);
                        textBox.setText(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(d));
                        dateHint.setText("");
                    }
                    catch (Exception e) {
                        ErrorPopup.showMessage((String)Constants.INSTANCE.BadDateFormatPleaseTryAgainTryTheFormatOf0("yyyy-MM-dd HH:mm"));
                    }
                }
            }
        });
        horizontalPanel.add((Widget)textBox);
        horizontalPanel.add((Widget)dateHint);
        return horizontalPanel;
    }
}

