/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellTableDropDownDataValueMapProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.GroupedDynamicDataRow;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.RowMapper;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CellStateChangedEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ColumnResizeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CopyRowsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertInternalColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.MoveColumnsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.PasteRowsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.RowGroupingChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SelectedCellChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetColumnVisibilityEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetInternalModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SortDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ToggleMergingEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDefinitionEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateSelectedCellsEvent;

public abstract class AbstractMergableGridWidget<M, T>
extends Widget
implements ToggleMergingEvent.Handler,
DeleteRowEvent.Handler,
InsertRowEvent.Handler,
AppendRowEvent.Handler,
CopyRowsEvent.Handler,
PasteRowsEvent.Handler,
DeleteColumnEvent.Handler,
SetInternalModelEvent.Handler<M, T>,
InsertInternalColumnEvent.Handler<T>,
SetColumnVisibilityEvent.Handler,
UpdateColumnDataEvent.Handler,
UpdateColumnDefinitionEvent.Handler,
ColumnResizeEvent.Handler,
MoveColumnsEvent.Handler,
SortDataEvent.Handler,
UpdateSelectedCellsEvent.Handler,
CellStateChangedEvent.Handler {
    protected TreeSet<CellValue<? extends Comparable<?>>> selections = new TreeSet(new Comparator<CellValue<? extends Comparable<?>>>(){

        @Override
        public int compare(CellValue<? extends Comparable<?>> o1, CellValue<? extends Comparable<?>> o2) {
            return o1.getPhysicalCoordinate().getRow() - o2.getPhysicalCoordinate().getRow();
        }
    });
    protected TableElement table;
    protected TableSectionElement tbody;
    protected ResourcesProvider<T> resources;
    protected EventBus eventBus;
    protected String selectorGroupedCellsHtml;
    protected String selectorUngroupedCellsHtml;
    protected List<DynamicColumn<T>> columns;
    protected DynamicData data;
    protected RowMapper rowMapper;
    protected AbstractCellFactory<T> cellFactory;
    protected AbstractCellValueFactory<T, ?> cellValueFactory;
    protected CellTableDropDownDataValueMapProvider dropDownManager;
    protected CellValue<?> rangeOriginCell;
    protected CellValue<?> rangeExtentCell;
    protected MOVE_DIRECTION rangeDirection = MOVE_DIRECTION.NONE;
    protected boolean bDragOperationPrimed = false;
    private List<DynamicDataRow> copiedRows = new ArrayList<DynamicDataRow>();
    protected static final RowGroupingChangeEvent ROW_GROUPING_EVENT = new RowGroupingChangeEvent();
    protected final boolean isReadOnly;

    private static native void disableTextSelectInternal(Element var0, boolean var1);

    public AbstractMergableGridWidget(ResourcesProvider<T> resources, AbstractCellFactory<T> cellFactory, AbstractCellValueFactory<T, ?> cellValueFactory, CellTableDropDownDataValueMapProvider dropDownManager, boolean isReadOnly, EventBus eventBus) {
        this.resources = resources;
        this.cellFactory = cellFactory;
        this.cellValueFactory = cellValueFactory;
        this.dropDownManager = dropDownManager;
        this.isReadOnly = isReadOnly;
        this.eventBus = eventBus;
        ImageResource selectorGroupedCells = resources.collapseCellsIcon();
        ImageResource selectorUngroupedCells = resources.expandCellsIcon();
        this.selectorGroupedCellsHtml = AbstractMergableGridWidget.makeImageHtml(selectorGroupedCells);
        this.selectorUngroupedCellsHtml = AbstractMergableGridWidget.makeImageHtml(selectorUngroupedCells);
        this.table = Document.get().createTableElement();
        this.tbody = Document.get().createTBodyElement();
        this.table.setClassName(resources.cellTable());
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.setElement((Element)this.table);
        this.table.appendChild((Node)this.tbody);
        this.sinkEvents(Event.getTypeInt((String)"click") | Event.getTypeInt((String)"dblclick") | Event.getTypeInt((String)"mousedown") | Event.getTypeInt((String)"mouseup") | Event.getTypeInt((String)"mousemove") | Event.getTypeInt((String)"mouseout") | Event.getTypeInt((String)"change") | Event.getTypeInt((String)"keypress") | Event.getTypeInt((String)"keydown"));
        AbstractMergableGridWidget.disableTextSelectInternal((Element)this.table, true);
        eventBus.addHandler(ToggleMergingEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CopyRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(PasteRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SetColumnVisibilityEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDataEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDefinitionEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ColumnResizeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(MoveColumnsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SortDataEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateSelectedCellsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CellStateChangedEvent.TYPE, (EventHandler)this);
    }

    private static String makeImageHtml(ImageResource image) {
        return AbstractImagePrototype.create((ImageResource)image).getHTML();
    }

    abstract void redraw();

    abstract void redrawColumns(int var1, int var2);

    private void applyModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        this.data.applyModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex = startCell.getCoordinate().getRow();
            GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)this.data.get(startRowIndex);
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - (startRowIndex > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 1 ? 1 : 0));
            for (int iRow = 0; iRow < groupedRow.getChildRows().size() - 1; ++iRow) {
                this.deleteRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    private boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int findMaxRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int maxRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue<Comparable<?>> cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow < this.data.size() - 1) {
                DynamicDataRow row = this.data.get(++iRow);
                cell = row.get(iCol);
            }
            maxRedrawRow = iRow > maxRedrawRow ? iRow : maxRedrawRow;
        }
        return maxRedrawRow;
    }

    private Coordinate findMergedCellExtent(Coordinate c) {
        if (c.getRow() == this.data.size() - 1) {
            return c;
        }
        Coordinate nc = new Coordinate(c.getRow() + 1, c.getCol());
        CellValue<Comparable<?>> newCell = this.data.get(nc);
        while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
            nc = new Coordinate(nc.getRow() + 1, nc.getCol());
            newCell = this.data.get(nc);
        }
        if (newCell.getRowSpan() != 0) {
            nc = new Coordinate(nc.getRow() - 1, nc.getCol());
        }
        return nc;
    }

    private int findMinRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int minRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue<Comparable<?>> cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow > 0) {
                DynamicDataRow row = this.data.get(--iRow);
                cell = row.get(iCol);
            }
            minRedrawRow = iRow < minRedrawRow ? iRow : minRedrawRow;
        }
        return minRedrawRow;
    }

    private Coordinate getNextCell(Coordinate c, MOVE_DIRECTION dir) {
        int step = 0;
        Coordinate nc = c;
        switch (dir) {
            case LEFT: {
                int n = step = c.getCol() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() - step);
                while (nc.getCol() > 0 && !this.columns.get(nc.getCol()).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() - step);
                }
                CellValue<Comparable<?>> newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case RIGHT: {
                int n = step = c.getCol() < this.columns.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() + step);
                while (nc.getCol() < this.columns.size() - 2 && !this.columns.get(nc.getCol()).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() + step);
                }
                if (!this.columns.get(nc.getCol()).isVisible()) {
                    nc = c;
                    break;
                }
                CellValue<Comparable<?>> newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case UP: {
                int n = step = c.getRow() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() - step, c.getCol());
                CellValue<Comparable<?>> newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case DOWN: {
                int n = step = c.getRow() < this.data.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() + step, c.getCol());
                CellValue<Comparable<?>> newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
                    nc = new Coordinate(nc.getRow() + step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                if (newCell.getRowSpan() != 0 || nc.getRow() != this.data.size() - 1) break;
                nc = c;
            }
        }
        return nc;
    }

    private void reindexColumns() {
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            DynamicColumn<T> col = this.columns.get(iCol);
            col.setColumnIndex(iCol);
        }
    }

    private void removeModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        List<DynamicDataRow> expandedRow = this.data.removeModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex;
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - ((startRowIndex = startCell.getCoordinate().getRow()) > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 2 ? 1 : 0));
            for (int iRow = 0; iRow < expandedRow.size() - 1; ++iRow) {
                this.createEmptyRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    protected void clearSelection() {
        for (CellValue<Comparable<?>> cell : this.selections) {
            cell.removeState(CellValue.CellState.SELECTED);
            this.deselectCell(cell);
        }
        this.selections.clear();
        this.rangeDirection = MOVE_DIRECTION.NONE;
        SelectedCellChangeEvent scce = new SelectedCellChangeEvent();
        this.eventBus.fireEvent((GwtEvent)scce);
    }

    abstract void createEmptyRowElement(int var1);

    abstract void createRowElement(int var1, DynamicDataRow var2);

    abstract void deleteRowElement(int var1);

    protected boolean isGroupWidgetClicked(Event event, Element target) {
        String tagName;
        String eventType = event.getType();
        return eventType.equals("mousedown") && "img".equalsIgnoreCase(tagName = target.getTagName());
    }

    abstract void redrawRows(int var1, int var2);

    abstract void removeRowElement(int var1);

    abstract void deselectCell(CellValue<? extends Comparable<?>> var1);

    void extendSelection(Coordinate end) {
        if (this.rangeOriginCell == null) {
            throw new IllegalArgumentException("origin has not been set. Unable to extend selection");
        }
        if (end == null) {
            throw new IllegalArgumentException("end cannot be null");
        }
        this.clearSelection();
        CellValue<Comparable<?>> endCell = this.data.get(end);
        this.selectRange(this.rangeOriginCell, endCell);
        if (this.rangeOriginCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            this.rangeExtentCell = this.selections.first();
            this.rangeDirection = MOVE_DIRECTION.UP;
        } else {
            this.rangeExtentCell = this.selections.last();
            this.rangeDirection = MOVE_DIRECTION.DOWN;
        }
    }

    void extendSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue<?> activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.clearSelection();
            this.rangeDirection = dir;
            this.rangeExtentCell = this.data.get(nc);
            this.selectRange(this.rangeOriginCell, this.rangeExtentCell);
        }
    }

    CellSelectionDetail getSelectedCellExtents(CellValue<? extends Comparable<?>> cv) {
        if (cv == null) {
            throw new IllegalArgumentException("cv cannot be null");
        }
        if (!this.columns.get(cv.getCoordinate().getCol()).isVisible()) {
            return null;
        }
        Coordinate hc = cv.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        int offsetX = tce.getOffsetLeft();
        int offsetY = tce.getOffsetTop();
        int w = tce.getOffsetWidth();
        int h = tce.getOffsetHeight();
        CellSelectionDetail e = new CellSelectionDetail(cv.getCoordinate(), offsetX, offsetY, h, w);
        return e;
    }

    void groupCells(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        CellValue<Comparable<?>> startCell = this.data.get(start);
        if (startCell.getRowSpan() <= 1 && !startCell.isGrouped()) {
            return;
        }
        this.clearSelection();
        if (startCell.isGrouped()) {
            this.removeModelGrouping(startCell, true);
        } else {
            this.applyModelGrouping(startCell, true);
        }
    }

    abstract void hideColumn(int var1);

    void moveSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue<?> activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.startSelecting(nc);
            this.rangeDirection = dir;
        }
    }

    abstract void resizeColumn(DynamicColumn<?> var1, int var2);

    abstract void selectCell(CellValue<? extends Comparable<?>> var1);

    void selectRange(CellValue<?> startCell, CellValue<?> endCell) {
        int col = startCell.getCoordinate().getCol();
        if (startCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            CellValue<?> swap = startCell;
            startCell = endCell;
            endCell = swap;
        }
        while (startCell.getRowSpan() == 0) {
            startCell = this.data.get(startCell.getCoordinate().getRow() - 1).get(col);
        }
        Coordinate nc = this.findMergedCellExtent(endCell.getCoordinate());
        endCell = this.data.get(nc);
        for (int iRow = startCell.getCoordinate().getRow(); iRow <= endCell.getCoordinate().getRow(); ++iRow) {
            CellValue<Comparable<?>> cell = this.data.get(iRow).get(col);
            this.selections.add(cell);
            cell.addState(CellValue.CellState.SELECTED);
            this.selectCell(cell);
        }
        switch (this.rangeDirection) {
            case DOWN: {
                this.rangeExtentCell = this.selections.last();
                break;
            }
            case UP: {
                this.rangeExtentCell = this.selections.first();
            }
        }
    }

    abstract void showColumn(int var1);

    void startSelecting(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        this.clearSelection();
        CellSelectionDetail ce = this.getSelectedCellExtents(this.data.get(start));
        SelectedCellChangeEvent scce = new SelectedCellChangeEvent(ce);
        this.eventBus.fireEvent((GwtEvent)scce);
        CellValue<? extends Comparable<?>> startCell = this.data.get(start);
        this.selectRange(startCell, startCell);
        this.rangeOriginCell = startCell;
        this.rangeExtentCell = null;
    }

    public void setData(DynamicData data) {
        this.data = data;
        this.rowMapper = new RowMapper(data);
    }

    public void setColumns(List<DynamicColumn<T>> columns) {
        this.columns = columns;
        this.reindexColumns();
    }

    @Override
    public void onToggleMerging(ToggleMergingEvent event) {
        this.clearSelection();
        if (event.isMerged()) {
            if (!this.data.isMerged()) {
                this.data.setMerged(true);
                this.redraw();
            }
        } else if (this.data.isMerged()) {
            this.data.setMerged(false);
            this.redraw();
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    @Override
    public void onDeleteRow(DeleteRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        this.clearSelection();
        this.data.deleteRow(index);
        this.removeRowElement(index);
        if (this.data.isMerged() && this.data.size() > 0) {
            int minRedrawRow = this.findMinRedrawRow(index - 1);
            int maxRedrawRow = this.findMaxRedrawRow(index - 1) + 1;
            if (maxRedrawRow > this.data.size() - 1) {
                maxRedrawRow = this.data.size() - 1;
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
    }

    @Override
    public void onInsertRow(InsertRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        DynamicDataRow rowData = this.cellValueFactory.makeUIRowData();
        this.insertRow(index, rowData);
    }

    @Override
    public void onAppendRow(AppendRowEvent event) {
        int index = this.data.size();
        DynamicDataRow rowData = this.cellValueFactory.makeUIRowData();
        this.insertRow(index, rowData);
    }

    @Override
    public void onCopyRows(CopyRowsEvent event) {
        this.copiedRows.clear();
        TreeSet<Integer> uniqueLogicalRowIndexes = new TreeSet<Integer>();
        for (Integer iRow : event.getRowIndexes()) {
            uniqueLogicalRowIndexes.add(this.rowMapper.mapToMergedRow(iRow));
        }
        for (Integer iRow : uniqueLogicalRowIndexes) {
            this.copiedRows.add(this.data.get(iRow));
        }
    }

    @Override
    public void onPasteRows(PasteRowsEvent event) {
        if (this.copiedRows == null || this.copiedRows.size() == 0) {
            return;
        }
        int iRow = this.rowMapper.mapToMergedRow(event.getTargetRowIndex());
        for (DynamicDataRow sourceRowData : this.copiedRows) {
            this.insertRow(iRow, this.cloneRow(sourceRowData));
            ++iRow;
        }
    }

    private DynamicDataRow cloneRow(DynamicDataRow sourceRowData) {
        if (sourceRowData instanceof GroupedDynamicDataRow) {
            return this.cloneDynamicDataRow((GroupedDynamicDataRow)sourceRowData);
        }
        return this.cloneDynamicDataRow(sourceRowData);
    }

    private DynamicDataRow cloneDynamicDataRow(DynamicDataRow sourceRowData) {
        DynamicDataRow rowData = this.cellValueFactory.makeUIRowData();
        for (int iCol = 0; iCol < sourceRowData.size(); ++iCol) {
            CellValue<Comparable<?>> cell = sourceRowData.get(iCol);
            rowData.get(iCol).setValue(cell.getValue());
        }
        return rowData;
    }

    private DynamicDataRow cloneDynamicDataRow(GroupedDynamicDataRow sourceRowData) {
        GroupedDynamicDataRow rowData = new GroupedDynamicDataRow();
        for (int iCol = 0; iCol < sourceRowData.size(); ++iCol) {
            CellValue<Comparable<?>> sourceCell = sourceRowData.get(iCol);
            CellValue.GroupedCellValue cell = sourceCell.convertToGroupedCell();
            if (sourceCell instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue groupedSourceCell = (CellValue.GroupedCellValue)sourceCell;
                if (groupedSourceCell.isGrouped()) {
                    cell.addState(CellValue.CellState.GROUPED);
                }
                if (groupedSourceCell.isOtherwise()) {
                    cell.addState(CellValue.CellState.OTHERWISE);
                }
            }
            rowData.add(cell);
        }
        for (DynamicDataRow childRow : sourceRowData.getChildRows()) {
            rowData.addChildRow(this.cloneRow(childRow));
        }
        return rowData;
    }

    private void insertRow(int index, DynamicDataRow rowData) {
        this.clearSelection();
        int minRedrawRow = index;
        int maxRedrawRow = index;
        if (this.data.isMerged() && index < this.data.size()) {
            minRedrawRow = this.findMinRedrawRow(index);
            maxRedrawRow = this.findMaxRedrawRow(index);
        }
        this.data.addRow(index, rowData);
        if (this.data.isMerged()) {
            if (index < this.data.size()) {
                minRedrawRow = Math.min(minRedrawRow, this.findMinRedrawRow(index));
                maxRedrawRow = Math.max(maxRedrawRow, this.findMaxRedrawRow(index));
            } else {
                minRedrawRow = Math.min(minRedrawRow, this.findMinRedrawRow(index));
                maxRedrawRow = index;
            }
        }
        if (!this.data.isMerged()) {
            this.createRowElement(index, rowData);
        } else {
            this.createEmptyRowElement(index);
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
    }

    @Override
    public void onDeleteColumn(DeleteColumnEvent event) {
        int iCol;
        int firstColumnIndex = event.getFirstColumnIndex();
        boolean bRedraw = event.redraw();
        boolean bRedrawSidebar = false;
        for (iCol = 0; iCol < event.getNumberOfColumns(); ++iCol) {
            for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                CellValue<Comparable<?>> cv = this.data.get(iRow).get(firstColumnIndex + iCol);
                if (!cv.isGrouped()) continue;
                this.removeModelGrouping(cv, false);
                bRedrawSidebar = true;
            }
        }
        this.clearSelection();
        for (iCol = 0; iCol < event.getNumberOfColumns(); ++iCol) {
            this.columns.remove(firstColumnIndex);
            this.data.deleteColumn(firstColumnIndex);
        }
        this.reindexColumns();
        if (bRedraw) {
            this.redraw();
            if (bRedrawSidebar) {
                this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
            }
        }
    }

    @Override
    public void onInsertInternalColumn(InsertInternalColumnEvent<T> event) {
        int index = event.getIndex();
        boolean bRedraw = event.redraw();
        this.clearSelection();
        for (int iCol = 0; iCol < event.getColumns().size(); ++iCol) {
            DynamicColumn<T> column = event.getColumns().get(iCol);
            List<CellValue<? extends Comparable<?>>> columnData = event.getColumnsData().get(iCol);
            this.columns.add(index + iCol, column);
            this.data.addColumn(index + iCol, columnData, column.isVisible());
        }
        this.reindexColumns();
        if (bRedraw) {
            this.redrawColumns(index, this.columns.size() - 1);
        }
    }

    @Override
    public void onSetInternalModel(SetInternalModelEvent<M, T> event) {
        this.dropDownManager.setData(event.getData());
        this.setColumns(event.getColumns());
        this.setData(event.getData());
        this.redraw();
    }

    @Override
    public void onSetColumnVisibility(SetColumnVisibilityEvent event) {
        int index = event.getIndex();
        boolean isVisible = event.isVisible();
        if (isVisible && !this.columns.get(index).isVisible()) {
            this.columns.get(index).setVisible(isVisible);
            this.data.setColumnVisibility(index, isVisible);
            this.showColumn(index);
        } else if (!isVisible && this.columns.get(index).isVisible()) {
            this.columns.get(index).setVisible(isVisible);
            this.data.setColumnVisibility(index, isVisible);
            this.hideColumn(index);
        }
    }

    @Override
    public void onUpdateColumnData(UpdateColumnDataEvent event) {
        int iRowIndex = 0;
        int iColIndex = event.getIndex();
        List<CellValue<Comparable<?>>> columnData = event.getColumnData();
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = this.data.get(iRow);
            CellValue<Comparable<?>> cell = columnData.get(iRowIndex);
            if (row instanceof GroupedDynamicDataRow) {
                GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                groupedRow.get(iColIndex).setValue(cell.getValue());
                for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                    cell = columnData.get(iRowIndex);
                    groupedRow.getChildRows().get(iGroupedRow).get(iColIndex).setValue(cell.getValue());
                    ++iRowIndex;
                }
                continue;
            }
            row.get(iColIndex).setValue(cell.getValue());
            ++iRowIndex;
        }
        this.data.assertModelMerging();
        this.redrawColumns(iColIndex, this.columns.size() - 1);
    }

    @Override
    public void onUpdateColumnDefinition(UpdateColumnDefinitionEvent event) {
        int index = event.getColumnIndex();
        DynamicColumn<T> column = this.columns.get(index);
        column.setCell(event.getCell());
        column.setSystemControlled(event.isSystemControlled());
        column.setSortable(event.isSortable());
    }

    @Override
    public void onColumnResize(ColumnResizeEvent event) {
        this.resizeColumn(event.getColumn(), event.getWidth());
    }

    @Override
    public void onMoveColumns(MoveColumnsEvent event) {
        int sourceColumnIndex = event.getSourceColumnIndex();
        int targetColumnIndex = event.getTargetColumnIndex();
        int numberOfColumns = event.getNumberOfColumns();
        int startRedrawIndex = sourceColumnIndex;
        int endRedrawIndex = targetColumnIndex;
        if (targetColumnIndex < sourceColumnIndex) {
            startRedrawIndex = targetColumnIndex;
            endRedrawIndex = sourceColumnIndex + numberOfColumns - 1;
        }
        if (targetColumnIndex > sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.columns.add(targetColumnIndex, this.columns.remove(sourceColumnIndex));
                for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                    DynamicDataRow row = this.data.get(iRow);
                    row.move(targetColumnIndex, sourceColumnIndex);
                }
            }
        } else if (targetColumnIndex < sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.columns.add(targetColumnIndex, this.columns.remove(sourceColumnIndex));
                for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                    DynamicDataRow row = this.data.get(iRow);
                    row.move(targetColumnIndex, sourceColumnIndex);
                }
                ++sourceColumnIndex;
                ++targetColumnIndex;
            }
        }
        this.reindexColumns();
        this.data.assertModelMerging();
        this.redrawColumns(startRedrawIndex, endRedrawIndex);
    }

    @Override
    public void onSortData(SortDataEvent event) {
        if (this.data.isGrouped()) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        List<SortConfiguration> sortConfiguration = event.getSortConfiguration();
        this.data.sort(sortConfiguration);
        this.redraw();
        ArrayList changedData = new ArrayList();
        for (DynamicDataRow row : this.data) {
            ArrayList changedRow = new ArrayList();
            changedData.add(changedRow);
            for (int iCol = 0; iCol < row.size() - 1; ++iCol) {
                CellValue<? extends Comparable<?>> changedCell = row.get(iCol);
                changedRow.add(changedCell);
            }
        }
        UpdateModelEvent dce = new UpdateModelEvent(new Coordinate(0, 0), changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    @Override
    public void onUpdateSelectedCells(UpdateSelectedCellsEvent event) {
        ArrayList changedRow;
        Comparable<?> value = event.getValue();
        HashMap changedData = new HashMap();
        Coordinate firstSelection = this.selections.first().getCoordinate();
        boolean bUngroupCells = false;
        if (this.selections.size() > 1) {
            for (CellValue<Comparable<?>> cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                bUngroupCells = true;
                break;
            }
        }
        ArrayList changedBlock = new ArrayList();
        for (CellValue<Comparable<?>> cell : this.selections) {
            changedRow = new ArrayList();
            Coordinate c = cell.getCoordinate();
            if (this.columns.get(c.getCol()).isSystemControlled()) continue;
            this.data.set(c, value);
            if (value != null) {
                cell.removeState(CellValue.CellState.OTHERWISE);
            }
            if (cell instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cell;
                for (int i = 0; i < gcv.getGroupedCells().size(); ++i) {
                    changedRow.add(this.data.get(c));
                    changedBlock.add(changedRow);
                }
                continue;
            }
            changedRow.add(this.data.get(c));
            changedBlock.add(changedRow);
        }
        Coordinate originSelected = new Coordinate(this.rowMapper.mapToAbsoluteRow(firstSelection.getRow()), firstSelection.getCol());
        changedData.put(originSelected, changedBlock);
        Cell.Context context = new Cell.Context(0, firstSelection.getCol(), null);
        Set<Integer> dependentColumnIndexes = this.dropDownManager.getDependentColumnIndexes(context);
        for (Integer n : dependentColumnIndexes) {
            changedBlock = new ArrayList();
            for (CellValue<Comparable<?>> cell : this.selections) {
                changedRow = new ArrayList();
                Coordinate dc = new Coordinate(cell.getCoordinate().getRow(), n);
                if (this.columns.get(dc.getCol()).isSystemControlled()) continue;
                this.data.set(dc, null);
                if (value != null) {
                    cell.removeState(CellValue.CellState.OTHERWISE);
                }
                if (cell instanceof CellValue.GroupedCellValue) {
                    CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cell;
                    for (int iChildValueIndex = 0; iChildValueIndex < gcv.getGroupedCells().size(); ++iChildValueIndex) {
                        changedRow.add(this.data.get(dc));
                        changedBlock.add(changedRow);
                    }
                    continue;
                }
                changedRow.add(this.data.get(dc));
                changedBlock.add(changedRow);
            }
            Coordinate originDependent = new Coordinate(this.rowMapper.mapToAbsoluteRow(firstSelection.getRow()), n);
            changedData.put(originDependent, changedBlock);
        }
        if (bUngroupCells) {
            for (CellValue cellValue : this.selections) {
                if (!(cellValue instanceof CellValue.GroupedCellValue)) continue;
                this.removeModelGrouping(cellValue, true);
            }
        } else if (this.data.isMerged() || this.selections.size() > 1) {
            this.data.assertModelMerging();
            int baseRowIndex = this.selections.first().getCoordinate().getRow();
            int n = this.findMinRedrawRow(baseRowIndex);
            int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
            if (maxRedrawRow < this.selections.last().getCoordinate().getRow()) {
                maxRedrawRow = this.selections.last().getCoordinate().getRow();
            }
            this.redrawRows(n, maxRedrawRow);
        } else {
            int baseRowIndex = this.selections.first().getCoordinate().getRow();
            this.redrawRows(baseRowIndex, baseRowIndex);
        }
        this.startSelecting(firstSelection);
        UpdateModelEvent dce = new UpdateModelEvent(changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    @Override
    public void onCellStateChanged(CellStateChangedEvent event) {
        Set<CellStateChangedEvent.CellStateOperation> states = event.getStates();
        boolean bUngroupCells = false;
        Coordinate selection = this.selections.first().getCoordinate();
        ArrayList changedData = new ArrayList();
        if (this.selections.size() > 1) {
            for (CellValue<Comparable<?>> cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                bUngroupCells = true;
                break;
            }
        }
        for (CellValue<Comparable<?>> cell : this.selections) {
            Coordinate c = cell.getCoordinate();
            if (this.columns.get(c.getCol()).isSystemControlled()) continue;
            CellValue<Comparable<?>> cv = this.data.get(c);
            for (CellStateChangedEvent.CellStateOperation state : states) {
                switch (state.getOperation()) {
                    case ADD: {
                        cv.addState(state.getState());
                        if (state.getState() != CellValue.CellState.OTHERWISE) break;
                        cv.setValue(null);
                        break;
                    }
                    case REMOVE: {
                        cv.removeState(state.getState());
                    }
                }
            }
            if (cell instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cell;
                for (int iChildValueIndex = 0; iChildValueIndex < gcv.getGroupedCells().size(); ++iChildValueIndex) {
                    ArrayList changedRow = new ArrayList();
                    changedRow.add(this.data.get(c));
                    changedData.add(changedRow);
                }
                continue;
            }
            ArrayList changedRow = new ArrayList();
            changedRow.add(this.data.get(c));
            changedData.add(changedRow);
        }
        if (bUngroupCells) {
            for (CellValue<Comparable<?>> cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                this.removeModelGrouping(cell, true);
            }
        } else {
            this.data.assertModelMerging();
            int baseRowIndex = this.selections.first().getCoordinate().getRow();
            int minRedrawRow = this.findMinRedrawRow(baseRowIndex);
            int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
            if (maxRedrawRow < this.selections.last().getCoordinate().getRow()) {
                maxRedrawRow = this.selections.last().getCoordinate().getRow();
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
        this.startSelecting(selection);
        UpdateModelEvent dce = new UpdateModelEvent(this.selections.first().getCoordinate(), changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    public static enum MOVE_DIRECTION {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        NONE;

    }

    public static class CellSelectionDetail {
        private Coordinate c;
        private int offsetX;
        private int offsetY;
        private int height;
        private int width;

        CellSelectionDetail(Coordinate c, int offsetX, int offsetY, int height, int width) {
            this.c = c;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.height = height;
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public int getWidth() {
            return this.width;
        }

        public Coordinate getCoordinate() {
            return this.c;
        }
    }
}

