/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.workitems;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.guvnor.client.common.IBindingProvider;
import org.drools.guvnor.client.common.NumericFloatTextBox;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.widgets.drools.workitems.WorkItemParameterWidget;
import org.drools.ide.common.shared.workitems.PortableFloatParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;

public class WorkItemFloatParameterWidget
extends WorkItemParameterWidget {
    @UiField
    Label parameterName;
    @UiField
    NumericFloatTextBox parameterEditor;
    @UiField
    ListBox lstAvailableBindings;
    private static WorkItemFloatParameterWidgetBinder uiBinder = (WorkItemFloatParameterWidgetBinder)GWT.create(WorkItemFloatParameterWidgetBinder.class);

    public WorkItemFloatParameterWidget(PortableFloatParameterDefinition ppd, IBindingProvider bindingProvider, boolean isReadOnly) {
        super((PortableParameterDefinition)ppd, bindingProvider);
        Set bindings;
        this.parameterName.setText(ppd.getName());
        this.parameterEditor.setEnabled(!isReadOnly);
        if (ppd.getValue() != null) {
            this.parameterEditor.setText(Float.toString(ppd.getValue().floatValue()));
        }
        if ((bindings = bindingProvider.getBindings(ppd.getClassName())).size() > 0) {
            this.lstAvailableBindings.clear();
            this.lstAvailableBindings.addItem(Constants.INSTANCE.Choose());
            this.lstAvailableBindings.setEnabled(!isReadOnly);
            this.lstAvailableBindings.setVisible(true);
            int selectedIndex = 0;
            for (String binding : bindings) {
                this.lstAvailableBindings.addItem(binding);
                if (!binding.equals(ppd.getBinding())) continue;
                selectedIndex = this.lstAvailableBindings.getItemCount() - 1;
            }
            this.lstAvailableBindings.setSelectedIndex(selectedIndex);
            this.parameterEditor.setEnabled(selectedIndex == 0 && !isReadOnly);
        }
    }

    @Override
    protected Widget getWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"parameterEditor"})
    void parameterEditorOnChange(ChangeEvent event) {
        try {
            ((PortableFloatParameterDefinition)this.ppd).setValue(Float.valueOf(Float.parseFloat(this.parameterEditor.getText())));
        }
        catch (NumberFormatException nfe) {
            ((PortableFloatParameterDefinition)this.ppd).setValue(null);
        }
    }

    @UiHandler(value={"lstAvailableBindings"})
    void lstAvailableBindingsOnChange(ChangeEvent event) {
        int index = this.lstAvailableBindings.getSelectedIndex();
        this.parameterEditor.setEnabled(index == 0);
        if (index > 0) {
            ((PortableFloatParameterDefinition)this.ppd).setValue(null);
            ((PortableFloatParameterDefinition)this.ppd).setBinding(this.lstAvailableBindings.getItemText(index));
        } else {
            ((PortableFloatParameterDefinition)this.ppd).setBinding("");
        }
    }

    static interface WorkItemFloatParameterWidgetBinder
    extends UiBinder<HorizontalPanel, WorkItemFloatParameterWidget> {
    }
}

