/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialTimelineCacheClusterPersistence;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.uberfire.backend.server.cluster.ClusterServiceFactoryProducer;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.message.MessageHandler;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.commons.message.MessageType;

@ApplicationScoped
public class SocialClusterMessaging {
    private Gson gson;
    private Type gsonCollectionType;
    private String cluster = "default";
    @Inject
    ClusterServiceFactoryProducer clusterServiceFactoryProducer;
    @Inject
    @Named(value="socialTimelinePersistence")
    SocialTimelinePersistenceAPI socialTimelinePersistence;
    @Inject
    SocialEventTypeRepositoryAPI socialEventTypeRepository;
    private ClusterService clusterService;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
        this.clusterService = this.clusterServiceFactoryProducer.clusterServiceFactory().build(new MessageHandlerResolver(){

            public String getServiceId() {
                return SocialClusterMessaging.this.cluster;
            }

            public MessageHandler resolveHandler(String serviceId, MessageType type) {
                return new MessageHandler(){

                    public Pair<MessageType, Map<String, String>> handleMessage(MessageType type, Map<String, String> content) {
                        if (type.equals((Object)SocialClusterMessage.SOCIAL_EVENT)) {
                            SocialClusterMessaging.this.handleSocialEvent(content);
                        }
                        if (type.equals((Object)SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE)) {
                            SocialClusterMessaging.this.handleSocialPersistenceEvent(content);
                        }
                        if (type.equals((Object)SocialClusterMessage.CLUSTER_SHUTDOWN)) {
                            SocialClusterMessaging.this.handleClusterShutdown();
                        }
                        return new Pair((Object)type, content);
                    }
                };
            }
        });
    }

    private void handleClusterShutdown() {
        SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
        cacheClusterPersistence.clusterShutDown();
    }

    private void handleSocialPersistenceEvent(Map<String, String> content) {
        SocialActivitiesEvent eventTypeName = null;
        SocialUser user = null;
        ArrayList events = new ArrayList();
        SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
        for (Map.Entry<String, String> entry : content.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(SocialClusterMessage.UPDATE_TYPE_EVENT.name())) {
                eventTypeName = (SocialActivitiesEvent)this.gson.fromJson(entry.getValue(), SocialActivitiesEvent.class);
            }
            if (!entry.getKey().equalsIgnoreCase(SocialClusterMessage.UPDATE_USER_EVENT.name())) continue;
            user = (SocialUser)this.gson.fromJson(entry.getValue(), SocialUser.class);
        }
        if (user == null || user.getUserName() == null) {
            SocialEventType typeEvent = this.socialEventTypeRepository.findType(eventTypeName.getType());
            cacheClusterPersistence.persist(SocialActivitiesEvent.getDummyLastWrittenMarker(), typeEvent, false);
        } else {
            cacheClusterPersistence.persist(user, SocialActivitiesEvent.getDummyLastWrittenMarker());
        }
    }

    private void handleSocialEvent(Map<String, String> content) {
        SocialActivitiesEvent event = null;
        SocialUser user = null;
        for (Map.Entry<String, String> entry : content.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(SocialClusterMessage.NEW_EVENT.name())) {
                event = (SocialActivitiesEvent)this.gson.fromJson(entry.getValue(), SocialActivitiesEvent.class);
            }
            if (!entry.getKey().equalsIgnoreCase(SocialClusterMessage.NEW_EVENT_USER.name())) continue;
            user = (SocialUser)this.gson.fromJson(entry.getValue(), SocialUser.class);
        }
        if (event != null) {
            SocialEventType typeEvent = this.socialEventTypeRepository.findType(event.getType());
            SocialTimelineCacheClusterPersistence cacheClusterPersistence = (SocialTimelineCacheClusterPersistence)this.socialTimelinePersistence;
            cacheClusterPersistence.persist(event, typeEvent, false);
            if (user != null) {
                cacheClusterPersistence.persist(user, event);
            }
        }
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
        this.gsonCollectionType = new TypeToken<Collection<SocialActivitiesEvent>>(){}.getType();
    }

    public void notify(SocialActivitiesEvent event) {
        String eventJson = this.gson.toJson((Object)event);
        HashMap<String, String> content = new HashMap<String, String>();
        content.put(SocialClusterMessage.NEW_EVENT.name(), eventJson);
        content.put(SocialClusterMessage.NEW_EVENT_USER.name(), eventJson);
        this.clusterService.broadcast(this.cluster, (MessageType)SocialClusterMessage.SOCIAL_EVENT, content);
    }

    public void notifyTimeLineUpdate(SocialActivitiesEvent event) {
        HashMap<String, String> content = new HashMap<String, String>();
        String json = this.gson.toJson((Object)event);
        content.put(SocialClusterMessage.UPDATE_TYPE_EVENT.name(), json);
        this.clusterService.broadcast(this.cluster, (MessageType)SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE, content);
    }

    public void notifyTimeLineUpdate(SocialUser user, List<SocialActivitiesEvent> storedEvents) {
        HashMap<String, String> content = new HashMap<String, String>();
        String json = this.gson.toJson((Object)user);
        content.put(SocialClusterMessage.UPDATE_USER_EVENT.name(), json);
        this.clusterService.broadcast(this.cluster, (MessageType)SocialClusterMessage.SOCIAL_FILE_SYSTEM_PERSISTENCE, content);
    }

    public boolean canILockFileSystem() {
        if (this.clusterService.isLocked()) {
            return false;
        }
        this.clusterService.lock();
        return true;
    }

    public void unlockFileSystem() {
        this.clusterService.unlock();
    }

    public void notifySomeInstanceisTakingCareOfShutdown() {
        this.clusterService.broadcast(this.cluster, (MessageType)SocialClusterMessage.CLUSTER_SHUTDOWN, new HashMap());
    }

    private static enum SocialClusterMessage implements MessageType
    {
        NEW_EVENT,
        NEW_EVENT_USER,
        UPDATE_TYPE_EVENT,
        UPDATE_USER_EVENT,
        SOCIAL_EVENT,
        SOCIAL_FILE_SYSTEM_PERSISTENCE,
        CLUSTER_SHUTDOWN;

    }
}

