/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.codecs.PerDocProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocProducer;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.util.BytesRef;

public class SimpleTextDocValuesFormat
extends DocValuesFormat {
    private static final String DOC_VALUES_SEG_SUFFIX = "dv";

    public PerDocConsumer docsConsumer(PerDocWriteState state) throws IOException {
        return new SimpleTextPerDocConsumer(state, DOC_VALUES_SEG_SUFFIX);
    }

    public PerDocProducer docsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextPerDocProducer(state, BytesRef.getUTF8SortedAsUnicodeComparator(), DOC_VALUES_SEG_SUFFIX);
    }

    static String docValuesId(String segmentsName, int fieldId) {
        return segmentsName + "_" + fieldId;
    }
}

