/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.access;

import java.io.Serializable;

public class AccessType
implements Serializable {
    public static final AccessType READ_ONLY = new AccessType("read-only");
    public static final AccessType READ_WRITE = new AccessType("read-write");
    public static final AccessType NONSTRICT_READ_WRITE = new AccessType("nonstrict-read-write");
    public static final AccessType TRANSACTIONAL = new AccessType("transactional");
    private final String name;

    private AccessType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "AccessType[" + this.name + "]";
    }

    private static AccessType resolve(String name) {
        if (AccessType.READ_ONLY.name.equals(name)) {
            return READ_ONLY;
        }
        if (AccessType.READ_WRITE.name.equals(name)) {
            return READ_WRITE;
        }
        if (AccessType.NONSTRICT_READ_WRITE.name.equals(name)) {
            return NONSTRICT_READ_WRITE;
        }
        if (AccessType.TRANSACTIONAL.name.equals(name)) {
            return TRANSACTIONAL;
        }
        return null;
    }

    public static AccessType parse(String name) {
        return AccessType.resolve(name);
    }

    private Object readResolve() {
        return AccessType.resolve(this.name);
    }

    public static String getValidUsageString() {
        return "cache usage attribute should be " + AccessType.READ_ONLY.name + ", " + AccessType.READ_WRITE.name + ", " + AccessType.NONSTRICT_READ_WRITE.name + ", or " + AccessType.TRANSACTIONAL.name;
    }
}

