/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.drools.repository.util.ClassUtil;

public abstract class JCRRepositoryConfigurator {
    public static final String JCR_IMPL_CLASS = "org.drools.repository.jcr.impl";
    public static final String REPOSITORY_ROOT_DIRECTORY = "repository.root.directory";
    protected static String defaultJCRImplClass = null;
    protected RepositoryFactory factory;
    protected Repository repository;

    public Repository getJCRRepository(Properties properties) throws RepositoryException {
        try {
            String jcrImplementationClass = properties.getProperty(JCR_IMPL_CLASS);
            if (jcrImplementationClass == null) {
                jcrImplementationClass = defaultJCRImplClass;
            }
            Class jcrFactory = ClassUtil.forName(jcrImplementationClass, this.getClass());
            RepositoryFactory factory = (RepositoryFactory)jcrFactory.newInstance();
            this.repository = factory.getRepository((Map)properties);
            this.factory = factory;
            return this.repository;
        }
        catch (Exception re) {
            throw new RepositoryException((Throwable)re);
        }
    }

    public abstract Session login(String var1) throws RepositoryException;

    public Session login(String userName, String password) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials(userName, password.toCharArray());
        return this.repository.login((Credentials)credentials);
    }

    public abstract void registerNodeTypesFromCndFile(String var1, Session var2, Workspace var3) throws RepositoryException;

    public abstract void shutdown();
}

