/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;

@Deprecated
final class FSTSynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private SynonymMap map;
    private boolean ignoreCase;

    FSTSynonymFilterFactory() {
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.map.fst == null ? input : new SynonymFilter(input, this.map, this.ignoreCase);
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        block4: {
            boolean ignoreCase;
            this.ignoreCase = ignoreCase = this.getBoolean("ignoreCase", false);
            String tf = (String)this.args.get("tokenizerFactory");
            final TokenizerFactory factory = tf == null ? null : this.loadTokenizerFactory(loader, tf);
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                    WhitespaceTokenizer tokenizer = factory == null ? new WhitespaceTokenizer(Version.LUCENE_31, reader) : factory.create(reader);
                    Object stream = ignoreCase ? new LowerCaseFilter(Version.LUCENE_31, (TokenStream)tokenizer) : tokenizer;
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
                }
            };
            String format = (String)this.args.get("format");
            try {
                if (format == null || format.equals("solr")) {
                    this.map = this.loadSolrSynonyms(loader, true, analyzer);
                    break block4;
                }
                if (format.equals("wordnet")) {
                    this.map = this.loadWordnetSynonyms(loader, true, analyzer);
                    break block4;
                }
                throw new IllegalArgumentException("Unrecognized synonyms format: " + format);
            }
            catch (ParseException e) {
                throw new IOException("Exception thrown while loading synonyms", e);
            }
        }
    }

    private SynonymMap loadSolrSynonyms(ResourceLoader loader, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        boolean expand = this.getBoolean("expand", true);
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new IllegalArgumentException("Missing required argument 'synonyms'.");
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        SolrSynonymParser parser = new SolrSynonymParser(dedup, expand, analyzer);
        File synonymFile = new File(synonyms);
        if (synonymFile.exists()) {
            decoder.reset();
            parser.add(new InputStreamReader(loader.openResource(synonyms), decoder));
        } else {
            List<String> files = this.splitFileNames(synonyms);
            for (String file : files) {
                decoder.reset();
                parser.add(new InputStreamReader(loader.openResource(file), decoder));
            }
        }
        return parser.build();
    }

    private SynonymMap loadWordnetSynonyms(ResourceLoader loader, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        boolean expand = this.getBoolean("expand", true);
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new IllegalArgumentException("Missing required argument 'synonyms'.");
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        WordnetSynonymParser parser = new WordnetSynonymParser(dedup, expand, analyzer);
        File synonymFile = new File(synonyms);
        if (synonymFile.exists()) {
            decoder.reset();
            parser.add(new InputStreamReader(loader.openResource(synonyms), decoder));
        } else {
            List<String> files = this.splitFileNames(synonyms);
            for (String file : files) {
                decoder.reset();
                parser.add(new InputStreamReader(loader.openResource(file), decoder));
            }
        }
        return parser.build();
    }

    private TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname) throws IOException {
        TokenizerFactory tokFactory = loader.newInstance(cname, TokenizerFactory.class);
        tokFactory.setLuceneMatchVersion(this.luceneMatchVersion);
        tokFactory.init(this.args);
        if (tokFactory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)((Object)tokFactory)).inform(loader);
        }
        return tokFactory;
    }
}

