/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.events.SystemMessage;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.forge.roaster.model.SyntaxError;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationMemberDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.JavaTypeInfoTO;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeInfo;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.PropertyTypeFactory;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationMemberDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverError;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class DataModelerServiceHelper {
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private User identity;
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    private ProjectService<?> projectService;

    public DataModel to2Domain(DataModelTO dataModelTO) {
        DataModel dataModel = ModelFactoryImpl.getInstance().newModel();
        List dataObjects = dataModelTO.getDataObjects();
        if (dataObjects != null) {
            for (DataObjectTO dataObjectTO : dataObjects) {
                DataObject dataObject = dataModel.addDataObject(dataObjectTO.getPackageName(), dataObjectTO.getName());
                this.to2Domain(dataObjectTO, dataObject);
            }
        }
        return dataModel;
    }

    public DataModelTO domain2To(DataModel dataModel, Map<String, Path> classPaths, DataModelTO.TOStatus initialStatus, boolean calculateFingerprints) throws Exception {
        DataObjectTO dataObjectTO;
        DataModelTO dataModelTO = new DataModelTO();
        ArrayList dataObjects = new ArrayList();
        ArrayList externalDataObjects = new ArrayList();
        HashMap<String, String> externalClasses = new HashMap<String, String>();
        dataObjects.addAll(dataModel.getDataObjects());
        externalDataObjects.addAll(dataModel.getDataObjects(ObjectSource.DEPENDENCY));
        if (dataObjects != null) {
            for (DataObject dataObject : dataObjects) {
                dataObjectTO = new DataObjectTO(dataObject.getName(), dataObject.getPackageName(), dataObject.getSuperClassName(), dataObject.isAbstract(), dataObject.isInterface(), dataObject.isFinal());
                if (initialStatus != null) {
                    dataObjectTO.setStatus(initialStatus);
                }
                this.domain2To(dataObject, dataObjectTO, initialStatus);
                dataModelTO.getDataObjects().add(dataObjectTO);
                if (calculateFingerprints) {
                    dataObjectTO.setFingerPrint(this.calculateFingerPrint(dataObjectTO.getStringId()));
                }
                if (classPaths == null || classPaths.get(dataObjectTO.getClassName()) == null) continue;
                dataObjectTO.setPath(Paths.convert((Path)classPaths.get(dataObjectTO.getClassName())));
            }
        }
        for (DataObject externalDataObject : externalDataObjects) {
            dataObjectTO = new DataObjectTO(externalDataObject.getName(), externalDataObject.getPackageName(), externalDataObject.getSuperClassName(), externalDataObject.isAbstract(), externalDataObject.isInterface(), externalDataObject.isFinal());
            if (externalClasses.containsKey(dataObjectTO.getClassName())) continue;
            dataModelTO.getExternalClasses().add(dataObjectTO);
            externalClasses.put(dataObjectTO.getClassName(), dataObjectTO.getClassName());
        }
        return dataModelTO;
    }

    public void domain2To(DataObject dataObject, DataObjectTO dataObjectTO, DataModelTO.TOStatus initialStatus) {
        dataObjectTO.setName(dataObject.getName());
        dataObjectTO.setPackageName(dataObject.getPackageName());
        dataObjectTO.setOriginalClassName(dataObject.getClassName());
        dataObjectTO.setSuperClassName(dataObject.getSuperClassName());
        ArrayList properties = new ArrayList();
        properties.addAll(dataObject.getProperties().values());
        ArrayList<ObjectPropertyTO> propertiesTO = new ArrayList<ObjectPropertyTO>();
        PropertyTypeFactory typeFactory = PropertyTypeFactoryImpl.getInstance();
        for (Annotation annotation : dataObject.getAnnotations()) {
            AnnotationTO annotationTO = this.domain2To(annotation);
            if (annotationTO == null) continue;
            dataObjectTO.addAnnotation(annotationTO);
        }
        for (ObjectProperty property : properties) {
            ObjectPropertyTO propertyTO = new ObjectPropertyTO(property.getName(), property.getClassName(), property.isMultiple(), typeFactory.isBasePropertyType(property.getClassName()), property.getBag(), property.getModifiers());
            propertyTO.setOriginalName(property.getName());
            if (initialStatus != null) {
                propertyTO.setStatus(initialStatus);
            }
            propertiesTO.add(propertyTO);
            for (Annotation annotation : property.getAnnotations()) {
                AnnotationTO annotationTO = this.domain2To(annotation);
                if (annotationTO == null) continue;
                propertyTO.addAnnotation(annotationTO);
            }
        }
        dataObjectTO.setProperties(propertiesTO);
    }

    public DataObject to2Domain(DataObjectTO dataObjectTO) {
        DataObjectImpl dataObject = new DataObjectImpl(dataObjectTO.getPackageName(), dataObjectTO.getName());
        this.to2Domain(dataObjectTO, (DataObject)dataObject);
        return dataObject;
    }

    public void to2Domain(DataObjectTO dataObjectTO, DataObject dataObject) {
        dataObject.setName(dataObjectTO.getName());
        List properties = dataObjectTO.getProperties();
        dataObject.setSuperClassName(dataObjectTO.getSuperClassName());
        for (AnnotationTO annotationTO : dataObjectTO.getAnnotations()) {
            Annotation annotation = this.to2Domain(annotationTO);
            if (annotation == null) continue;
            dataObject.addAnnotation(annotation);
        }
        if (properties != null) {
            for (ObjectPropertyTO propertyTO : properties) {
                ObjectProperty property = dataObject.addProperty(propertyTO.getName(), propertyTO.getClassName(), propertyTO.isMultiple(), propertyTO.getBag(), propertyTO.getModifiers());
                for (AnnotationTO annotationTO : propertyTO.getAnnotations()) {
                    Annotation annotation = this.to2Domain(annotationTO);
                    if (annotation == null) continue;
                    property.addAnnotation(annotation);
                }
            }
        }
    }

    public ObjectProperty to2Domain(ObjectPropertyTO propertyTO) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(propertyTO.getName(), propertyTO.getClassName(), propertyTO.isMultiple(), propertyTO.getBag(), propertyTO.getModifiers());
        for (AnnotationTO annotationTO : propertyTO.getAnnotations()) {
            Annotation annotation = this.to2Domain(annotationTO);
            if (annotation == null) continue;
            property.addAnnotation(annotation);
        }
        return property;
    }

    public Annotation to2Domain(AnnotationTO annotationTO) {
        AnnotationDefinition annotationDefinition = this.to2Domain(annotationTO.getAnnotationDefinition());
        AnnotationImpl annotation = new AnnotationImpl(annotationDefinition);
        for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
            Object memberValue = annotationTO.getValue(memberDefinition.getName());
            if (memberValue == null) continue;
            annotation.setValue(memberDefinition.getName(), memberValue);
        }
        return annotation;
    }

    public AnnotationDefinition to2Domain(AnnotationDefinitionTO annotationDefinitionTO) {
        AnnotationDefinitionImpl annotationDefinition = new AnnotationDefinitionImpl(annotationDefinitionTO.getName(), annotationDefinitionTO.getClassName(), annotationDefinitionTO.getShortDescription(), annotationDefinitionTO.getDescription(), annotationDefinitionTO.isObjectAnnotation(), annotationDefinitionTO.isPropertyAnnotation());
        for (AnnotationMemberDefinitionTO memberDefinitionTO : annotationDefinitionTO.getAnnotationMembers()) {
            AnnotationMemberDefinitionImpl memberDefinition = new AnnotationMemberDefinitionImpl(memberDefinitionTO.getName(), memberDefinitionTO.getClassName(), memberDefinitionTO.isEnum(), memberDefinitionTO.getDefaultValue(), memberDefinitionTO.getShortDescription(), memberDefinitionTO.getDescription());
            annotationDefinition.addMember((AnnotationMemberDefinition)memberDefinition);
        }
        return annotationDefinition;
    }

    public AnnotationTO domain2To(Annotation annotation) {
        AnnotationDefinitionTO annotationDefinitionTO = this.domain2To(annotation.getAnnotationDefinition());
        AnnotationTO annotationTO = new AnnotationTO(annotationDefinitionTO);
        for (AnnotationMemberDefinitionTO memberDefinitionTO : annotationDefinitionTO.getAnnotationMembers()) {
            Object memberValue = annotation.getValue(memberDefinitionTO.getName());
            if (memberValue == null) continue;
            annotationTO.setValue(memberDefinitionTO.getName(), memberValue);
        }
        return annotationTO;
    }

    public AnnotationDefinitionTO domain2To(AnnotationDefinition annotationDefinition) {
        AnnotationDefinitionTO annotationDefinitionTO = new AnnotationDefinitionTO(annotationDefinition.getName(), annotationDefinition.getClassName(), annotationDefinition.getShortDescription(), annotationDefinition.getDescription(), annotationDefinition.isObjectAnnotation(), annotationDefinition.isPropertyAnnotation());
        for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
            AnnotationMemberDefinitionTO memberDefinitionTO = new AnnotationMemberDefinitionTO(memberDefinition.getName(), memberDefinition.getClassName(), memberDefinition.isPrimitiveType(), memberDefinition.isEnum(), memberDefinition.defaultValue(), memberDefinition.getShortDescription(), memberDefinition.getDescription());
            annotationDefinitionTO.addMember(memberDefinitionTO);
        }
        return annotationDefinitionTO;
    }

    public JavaTypeInfoTO domain2TO(JavaTypeInfo javaTypeInfo) {
        if (javaTypeInfo == null) {
            return null;
        }
        JavaTypeInfoTO javaTypeInfoTO = new JavaTypeInfoTO(javaTypeInfo.getName(), javaTypeInfo.getPackageName());
        javaTypeInfoTO.setAnnotation(javaTypeInfo.isAnnotation());
        javaTypeInfoTO.setClass(javaTypeInfo.isClass());
        javaTypeInfoTO.setInterface(javaTypeInfo.isInterface());
        javaTypeInfoTO.setEnum(javaTypeInfo.isEnum());
        javaTypeInfoTO.setPackagePrivate(javaTypeInfo.isPackagePrivate());
        javaTypeInfoTO.setPrivate(javaTypeInfo.isPrivate());
        javaTypeInfoTO.setProtected(javaTypeInfo.isProtected());
        javaTypeInfoTO.setPublic(javaTypeInfo.isPublic());
        return javaTypeInfoTO;
    }

    public String calculateFingerPrint(String str) {
        return Base64.encodeBase64String((byte[])DigestUtils.sha((String)str));
    }

    public String calculateFingerPrint(Object obj) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.close();
        byte[] fingerPrint = DigestUtils.sha((byte[])byteArrayOutputStream.toByteArray());
        return Base64.encodeBase64String((byte[])fingerPrint);
    }

    public Map<String, String> claculateFingerPrints(DataModelTO dataModelTO) {
        HashMap<String, String> fingerPrints = new HashMap<String, String>();
        for (DataObjectTO dataObjectTO : dataModelTO.getDataObjects()) {
            fingerPrints.put(dataObjectTO.getClassName(), this.calculateFingerPrint(dataObjectTO.getStringId()));
        }
        return fingerPrints;
    }

    public Map<String, String> calculatePersistentDataObjectRenames(DataModelTO dataModelTO) {
        HashMap<String, String> renames = new HashMap<String, String>();
        for (DataObjectTO dataObjectTO : dataModelTO.getDataObjects()) {
            if (dataObjectTO.isVolatile() || !dataObjectTO.classNameChanged()) continue;
            renames.put(dataObjectTO.getOriginalClassName(), dataObjectTO.getClassName());
        }
        return renames;
    }

    public List<String> calculatePersistentDataObjectDeletions(DataModelTO dataModelTO) {
        ArrayList<String> deletions = new ArrayList<String>();
        for (DataObjectTO dataObjectTO : dataModelTO.getDeletedDataObjects()) {
            if (dataObjectTO.isVolatile()) continue;
            deletions.add(dataObjectTO.getOriginalClassName());
        }
        return deletions;
    }

    public List<DataModelerError> toDataModelerError(List<ModelDriverError> errors) {
        ArrayList<DataModelerError> result = new ArrayList<DataModelerError>();
        if (errors == null) {
            return result;
        }
        for (ModelDriverError error : errors) {
            DataModelerError dataModelerError = new DataModelerError(error.getId(), error.getMessage(), SystemMessage.Level.ERROR, Paths.convert((Path)error.getFile()), error.getLine(), error.getColumn());
            result.add(dataModelerError);
        }
        return result;
    }

    public List<DataModelerError> toDataModelerError(List<SyntaxError> syntaxErrors, Path file) {
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        for (SyntaxError syntaxError : syntaxErrors) {
            DataModelerError error = new DataModelerError(syntaxError.getDescription(), syntaxError.isError() ? SystemMessage.Level.ERROR : SystemMessage.Level.WARNING, Paths.convert((Path)file));
            error.setColumn(syntaxError.getColumn());
            error.setLine(syntaxError.getLine());
            errors.add(error);
        }
        return errors;
    }

    public List<ValidationMessage> toValidationMessage(List<DataModelerError> errors) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (errors == null) {
            return validationMessages;
        }
        for (DataModelerError error : errors) {
            ValidationMessage validationMessage = new ValidationMessage();
            validationMessage.setPath(error.getFile());
            validationMessage.setText(error.getMessage());
            validationMessage.setColumn(error.getColumn());
            validationMessage.setLine(error.getLine());
            validationMessage.setId(error.getId());
            if (error.getLevel() != null) {
                switch (error.getLevel()) {
                    case ERROR: {
                        validationMessage.setLevel(ValidationMessage.Level.ERROR);
                        break;
                    }
                    case WARNING: {
                        validationMessage.setLevel(ValidationMessage.Level.WARNING);
                        break;
                    }
                    case INFO: {
                        validationMessage.setLevel(ValidationMessage.Level.INFO);
                        break;
                    }
                    default: {
                        validationMessage.setLevel(ValidationMessage.Level.ERROR);
                    }
                }
            }
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getIdentifier();
        Date when = new Date();
        CommentedOption option = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return option;
    }

    public Package ensurePackageStructure(Project project, String packageName) {
        Package defaultPackage;
        if (packageName == null || "".equals(packageName) || project == null) {
            return null;
        }
        Package subPackage = defaultPackage = this.projectService.resolveDefaultPackage(project);
        Path subDirPath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath());
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (tokenizer.hasMoreTokens()) {
            String subDirName = tokenizer.nextToken();
            if (!this.ioService.exists(subDirPath = subDirPath.resolve(subDirName))) {
                subPackage = this.projectService.newPackage(subPackage, subDirName);
                continue;
            }
            subPackage = this.projectService.resolvePackage(Paths.convert((Path)subDirPath));
        }
        return subPackage;
    }

    public String getCanonicalFileName(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        String fileName = path.getFileName();
        return fileName.substring(0, fileName.indexOf("."));
    }
}

