/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.query.standard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.JavaTypeIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindJavaTypeQuery
implements NamedQuery {
    @Inject
    private DefaultResponseBuilder responseBuilder;

    public String getName() {
        return "FindJavaTypeQuery";
    }

    public Set<IndexTerm> getTerms() {
        HashSet<IndexTerm> terms = new HashSet<IndexTerm>();
        terms.add((IndexTerm)new JavaTypeIndexTerm());
        return terms;
    }

    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.size() == 0) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'java_type'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm javaTypeTerm = normalizedTerms.get("java_type");
        if (javaTypeTerm == null) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'java_type'.");
        }
        QueryBuilder builder = new QueryBuilder();
        if (useWildcards) {
            builder.useWildcards();
        }
        for (ValueIndexTerm valueIndexTerm : normalizedTerms.values()) {
            builder.addTerm(valueIndexTerm);
        }
        return builder.build();
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }
}

