/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.UnknownCommand;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitSSHService {
    final SshServer sshd = SshServer.setUpDefaultServer();
    private FileSystemAuthenticator fileSystemAuthenticator;
    private FileSystemAuthorizer fileSystemAuthorizer;

    public void setup(File certDir, String host, int port, FileSystemAuthenticator fileSystemAuthenticator, FileSystemAuthorizer fileSystemAuthorizer, final ReceivePackFactory receivePackFactory, final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver) {
        this.fileSystemAuthenticator = fileSystemAuthenticator;
        this.fileSystemAuthorizer = fileSystemAuthorizer;
        this.sshd.getProperties().put("idle-timeout", "10000");
        this.sshd.setHost(host);
        this.sshd.setPort(port);
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser").getAbsolutePath()));
        this.sshd.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                if (command.startsWith("git-upload-pack")) {
                    return new GitUploadCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager());
                }
                if (command.startsWith("git-receive-pack")) {
                    return new GitReceiveCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), (ReceivePackFactory<BaseGitCommand>)receivePackFactory);
                }
                return new UnknownCommand(command);
            }
        });
        this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                FileSystemUser user = GitSSHService.this.getUserPassAuthenticator().authenticate(username, password);
                if (user == null) {
                    return false;
                }
                session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
                return true;
            }
        });
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't start SSH daemon at " + this.sshd.getHost() + ":" + this.sshd.getPort(), e);
        }
    }

    public FileSystemAuthenticator getUserPassAuthenticator() {
        return this.fileSystemAuthenticator;
    }

    public void setUserPassAuthenticator(FileSystemAuthenticator fileSystemAuthenticator) {
        this.fileSystemAuthenticator = fileSystemAuthenticator;
    }

    public FileSystemAuthorizer getAuthorizationManager() {
        return this.fileSystemAuthorizer;
    }

    public void setAuthorizationManager(FileSystemAuthorizer fileSystemAuthorizer) {
        this.fileSystemAuthorizer = fileSystemAuthorizer;
    }
}

