/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.spi.config.ConfigFilter;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.ServiceUtils;

@Typed
public final class ConfigResolver {
    private static final Logger LOG = Logger.getLogger(ConfigResolver.class.getName());
    private static Map<ClassLoader, ConfigSource[]> configSources = new ConcurrentHashMap<ClassLoader, ConfigSource[]>();
    private static Map<ClassLoader, List<ConfigFilter>> configFilters = new ConcurrentHashMap<ClassLoader, List<ConfigFilter>>();
    private static volatile ProjectStage projectStage = null;

    private ConfigResolver() {
    }

    public static synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ConfigResolver.getConfigSources();
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] configuredConfigSources = configSources.get(currentClassLoader);
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>();
        allConfigSources.addAll(Arrays.asList(configuredConfigSources));
        allConfigSources.addAll(configSourcesToAdd);
        configSources.put(currentClassLoader, ConfigResolver.sortDescending(allConfigSources));
    }

    public static synchronized void freeConfigSources() {
        configSources.remove(ClassUtils.getClassLoader(null));
    }

    public static void addConfigFilter(ConfigFilter configFilter) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getConfigFilters();
        currentConfigFilters.add(configFilter);
    }

    public static List<ConfigFilter> getConfigFilters() {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        List<ConfigFilter> currentConfigFilters = configFilters.get(cl);
        if (currentConfigFilters == null) {
            currentConfigFilters = new ArrayList<ConfigFilter>();
            configFilters.put(cl, currentConfigFilters);
        }
        return currentConfigFilters;
    }

    public static String getPropertyValue(String key, String defaultValue) {
        String value = ConfigResolver.getPropertyValue(key);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue);
    }

    public static String getPropertyValue(String key) {
        ConfigSource[] appConfigSources;
        for (ConfigSource configSource : appConfigSources = ConfigResolver.getConfigSources()) {
            String value = configSource.getPropertyValue(key);
            if (value != null) {
                LOG.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{ConfigResolver.filterConfigValueForLog(key, value), key, configSource.getConfigName()});
                return ConfigResolver.filterConfigValue(key, value);
            }
            LOG.log(Level.FINER, "NO value found for key {0} in ConfigSource {1}.", new Object[]{key, configSource.getConfigName()});
        }
        return null;
    }

    public static String getProjectStageAwarePropertyValue(String key) {
        ProjectStage ps = ConfigResolver.getProjectStage();
        String value = ConfigResolver.getPropertyValue(key + '.' + ps);
        if (value == null) {
            value = ConfigResolver.getPropertyValue(key);
        }
        return value;
    }

    public static String getProjectStageAwarePropertyValue(String key, String defaultValue) {
        String value = ConfigResolver.getProjectStageAwarePropertyValue(key);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue);
    }

    public static String getPropertyAwarePropertyValue(String key, String property) {
        String propertyValue = ConfigResolver.getProjectStageAwarePropertyValue(property);
        String value = null;
        if (propertyValue != null && propertyValue.length() > 0) {
            value = ConfigResolver.getProjectStageAwarePropertyValue(key + '.' + propertyValue);
        }
        if (value == null) {
            value = ConfigResolver.getProjectStageAwarePropertyValue(key);
        }
        return value;
    }

    public static String getPropertyAwarePropertyValue(String key, String property, String defaultValue) {
        String value = ConfigResolver.getPropertyAwarePropertyValue(key, property);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue);
    }

    public static List<String> getAllPropertyValues(String key) {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSource configSource : appConfigSources) {
            String value = configSource.getPropertyValue(key);
            if (value == null || result.contains(value = ConfigResolver.filterConfigValue(key, value))) continue;
            result.add(value);
        }
        return result;
    }

    public static Map<String, String> getAllProperties() {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        HashMap<String, String> result = new HashMap<String, String>();
        for (ConfigSource configSource : appConfigSources) {
            if (!configSource.isScannable()) continue;
            result.putAll(configSource.getProperties());
        }
        return Collections.unmodifiableMap(result);
    }

    private static synchronized ConfigSource[] getConfigSources() {
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] appConfigSources = configSources.get(currentClassLoader);
        if (appConfigSources == null) {
            appConfigSources = ConfigResolver.sortDescending(ConfigResolver.resolveConfigSources());
            if (LOG.isLoggable(Level.FINE)) {
                for (ConfigSource cs : appConfigSources) {
                    LOG.log(Level.FINE, "Adding ordinal {0} ConfigSource {1}", new Object[]{cs.getOrdinal(), cs.getConfigName()});
                }
            }
            configSources.put(currentClassLoader, appConfigSources);
        }
        return appConfigSources;
    }

    private static List<ConfigSource> resolveConfigSources() {
        List<ConfigSource> appConfigSources = ServiceUtils.loadServiceImplementations(ConfigSource.class);
        List<ConfigSourceProvider> configSourceProviderServiceLoader = ServiceUtils.loadServiceImplementations(ConfigSourceProvider.class);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderServiceLoader) {
            appConfigSources.addAll(configSourceProvider.getConfigSources());
        }
        return appConfigSources;
    }

    private static ConfigSource[] sortDescending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? -1 : 1;
            }
        });
        return configSources.toArray(new ConfigSource[configSources.size()]);
    }

    private static List<ConfigSource> sortAscending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? 1 : -1;
            }
        });
        return configSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProjectStage getProjectStage() {
        if (projectStage != null) return projectStage;
        Class<ConfigResolver> clazz = ConfigResolver.class;
        synchronized (ConfigResolver.class) {
            projectStage = ProjectStageProducer.getInstance().getProjectStage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return projectStage;
        }
    }

    private static String fallbackToDefaultIfEmpty(String key, String value, String defaultValue) {
        if (value == null || value.length() == 0) {
            LOG.log(Level.FINE, "no configured value found for key {0}, using default value {1}.", new Object[]{key, defaultValue});
            return defaultValue;
        }
        return value;
    }

    private static String filterConfigValue(String key, String value) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getConfigFilters();
        String filteredValue = value;
        for (ConfigFilter filter : currentConfigFilters) {
            filteredValue = filter.filterValue(key, filteredValue);
        }
        return filteredValue;
    }

    private static String filterConfigValueForLog(String key, String value) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getConfigFilters();
        String logValue = value;
        for (ConfigFilter filter : currentConfigFilters) {
            logValue = filter.filterValueForLog(key, logValue);
        }
        return logValue;
    }
}

