/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.TextSpecInfoRun;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;

public final class TextSpecInfoAtom
extends RecordAtom {
    private static final long _type = RecordTypes.TextSpecInfoAtom.typeID;
    private byte[] _header = new byte[8];
    private byte[] _data;

    public TextSpecInfoAtom() {
        LittleEndian.putUInt((byte[])this._header, (int)4, (long)_type);
        this.reset(1);
    }

    public TextSpecInfoAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public void setTextSize(int size) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)size);
    }

    public void reset(int size) {
        TextSpecInfoRun sir = new TextSpecInfoRun(size);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            sir.writeOut(bos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._data = bos.toByteArray();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    public void setParentSize(int size) {
        TextSpecInfoRun run;
        assert (size > 0);
        int covered = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TextSpecInfoRun[] runs = this.getTextSpecInfoRuns();
        assert (runs.length > 0);
        for (int i = 0; i < runs.length && covered < size; covered += run.getLength(), ++i) {
            run = runs[i];
            if (covered + run.getLength() > size || i == runs.length - 1) {
                run.setLength(size - covered);
            }
            try {
                run.writeOut(bos);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this._data = bos.toByteArray();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    public int getCharactersCovered() {
        int covered = 0;
        for (TextSpecInfoRun r : this.getTextSpecInfoRuns()) {
            covered += r.length;
        }
        return covered;
    }

    public TextSpecInfoRun[] getTextSpecInfoRuns() {
        LittleEndianByteArrayInputStream bis = new LittleEndianByteArrayInputStream(this._data);
        ArrayList<TextSpecInfoRun> lst = new ArrayList<TextSpecInfoRun>();
        while (bis.available() > 0) {
            lst.add(new TextSpecInfoRun(bis));
        }
        return lst.toArray(new TextSpecInfoRun[lst.size()]);
    }
}

