/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;

public final class TxMasterStyleAtom
extends RecordAtom {
    public static final int MAX_INDENT = 5;
    private byte[] _header = new byte[8];
    private static long _type = 4003L;
    private byte[] _data;
    private List<TextPropCollection> paragraphStyles;
    private List<TextPropCollection> charStyles;

    protected TxMasterStyleAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, this._data.length);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public List<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public List<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public int getTextType() {
        return LittleEndian.getShort((byte[])this._header, (int)0) >> 4;
    }

    protected void init() {
        int type = this.getTextType();
        int pos = 0;
        short levels = LittleEndian.getShort((byte[])this._data, (int)0);
        pos += 2;
        this.paragraphStyles = new ArrayList<TextPropCollection>(levels);
        this.charStyles = new ArrayList<TextPropCollection>(levels);
        for (short j = 0; j < levels; j = (short)(j + 1)) {
            TextPropCollection prprops = new TextPropCollection(0, TextPropCollection.TextPropType.paragraph);
            if (type >= 5) {
                short indentLevel = LittleEndian.getShort((byte[])this._data, (int)pos);
                prprops.setIndentLevel(indentLevel);
                pos += 2;
            } else {
                prprops.setIndentLevel((short)-1);
            }
            int head = LittleEndian.getInt((byte[])this._data, (int)pos);
            pos += 4;
            pos += prprops.buildTextPropList(head, this._data, pos);
            this.paragraphStyles.add(prprops);
            head = LittleEndian.getInt((byte[])this._data, (int)pos);
            pos += 4;
            TextPropCollection chprops = new TextPropCollection(0, TextPropCollection.TextPropType.character);
            pos += chprops.buildTextPropList(head, this._data, pos);
            this.charStyles.add(chprops);
        }
    }
}

