/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.FillStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSLFFill {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public static final int FILL_SOLID = 0;
    public static final int FILL_PATTERN = 1;
    public static final int FILL_TEXTURE = 2;
    public static final int FILL_PICTURE = 3;
    public static final int FILL_SHADE = 4;
    public static final int FILL_SHADE_CENTER = 5;
    public static final int FILL_SHADE_SHAPE = 6;
    public static final int FILL_SHADE_SCALE = 7;
    public static final int FILL_SHADE_TITLE = 8;
    public static final int FILL_BACKGROUND = 9;
    protected HSLFShape shape;

    public HSLFFill(HSLFShape shape) {
        this.shape = shape;
    }

    public FillStyle getFillStyle() {
        return new FillStyle(){

            public PaintStyle getPaint() {
                switch (HSLFFill.this.getFillType()) {
                    case 0: {
                        return DrawPaint.createSolidPaint((Color)HSLFFill.this.getForegroundColor());
                    }
                    case 3: {
                        final HSLFPictureData pd = HSLFFill.this.getPictureData();
                        if (pd == null) break;
                        return new PaintStyle.TexturePaint(){

                            public InputStream getImageData() {
                                return new ByteArrayInputStream(pd.getData());
                            }

                            public String getContentType() {
                                return pd.getContentType();
                            }

                            public int getAlpha() {
                                return (int)(HSLFFill.this.shape.getAlpha((short)386) * 100000.0);
                            }
                        };
                    }
                    default: {
                        HSLFFill.this.logger.log(5, new Object[]{"unsuported fill type: " + HSLFFill.this.getFillType()});
                    }
                }
                return null;
            }
        };
    }

    public int getFillType() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 384);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    protected void afterInsert(HSLFSheet sh) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 390);
        if (p != null) {
            int idx = p.getPropertyValue();
            EscherBSERecord bse = this.getEscherBSERecord(idx);
            bse.setRef(bse.getRef() + 1);
        }
    }

    protected EscherBSERecord getEscherBSERecord(int idx) {
        HSLFSheet sheet = this.shape.getSheet();
        if (sheet == null) {
            this.logger.log(1, new Object[]{"Fill has not yet been assigned to a sheet"});
            return null;
        }
        HSLFSlideShow ppt = sheet.getSlideShow();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)HSLFShape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            this.logger.log(1, new Object[]{"EscherContainerRecord.BSTORE_CONTAINER was not found "});
            return null;
        }
        List lst = bstore.getChildRecords();
        return (EscherBSERecord)lst.get(idx - 1);
    }

    public void setFillType(int type) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(opt, (short)384, type);
    }

    public Color getForegroundColor() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447);
        if (p != null && (p.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)385, (short)386, -1);
    }

    public void setForegroundColor(Color color) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        if (color == null) {
            HSLFShape.setEscherProperty(opt, (short)447, 0x150000);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(opt, (short)385, rgb);
            HSLFShape.setEscherProperty(opt, (short)447, 0x150011);
        }
    }

    public Color getBackgroundColor() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447);
        if (p != null && (p.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)387, (short)386, -1);
    }

    public void setBackgroundColor(Color color) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        if (color == null) {
            HSLFShape.setEscherProperty(opt, (short)387, -1);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(opt, (short)387, rgb);
        }
    }

    public HSLFPictureData getPictureData() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 390);
        if (p == null) {
            return null;
        }
        HSLFSlideShow ppt = this.shape.getSheet().getSlideShow();
        List<HSLFPictureData> pict = ppt.getPictureData();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)HSLFShape.getEscherChild(dggContainer, -4095);
        List lst = bstore.getChildRecords();
        int idx = p.getPropertyValue();
        if (idx == 0) {
            this.logger.log(5, new Object[]{"no reference to picture data found "});
        } else {
            EscherBSERecord bse = (EscherBSERecord)lst.get(idx - 1);
            for (HSLFPictureData pd : pict) {
                if (pd.getOffset() != bse.getOffset()) continue;
                return pd;
            }
        }
        return null;
    }

    public void setPictureData(HSLFPictureData data) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(opt, (short)16774, data == null ? 0 : data.getIndex());
        if (data != null && this.shape.getSheet() != null) {
            EscherBSERecord bse = this.getEscherBSERecord(data.getIndex());
            bse.setRef(bse.getRef() + 1);
        }
    }
}

