/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFConnectorShape;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFShapeContainer;
import org.apache.poi.hslf.usermodel.HSLFShapeFactory;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.GroupShape;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public class HSLFGroupShape
extends HSLFShape
implements HSLFShapeContainer,
GroupShape<HSLFShape, HSLFTextParagraph> {
    public HSLFGroupShape() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    public HSLFGroupShape(ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        this(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof HSLFGroupShape);
    }

    protected HSLFGroupShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    @Override
    public void setAnchor(Rectangle anchor) {
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)this.getEscherChild(-4080);
        byte[] header = new byte[16];
        LittleEndian.putUShort((byte[])header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])header, (int)2, (int)0);
        LittleEndian.putInt((byte[])header, (int)4, (int)8);
        clientAnchor.fillFields(header, 0, null);
        clientAnchor.setFlag((short)Units.pointsToMaster((double)anchor.y));
        clientAnchor.setCol1((short)Units.pointsToMaster((double)anchor.x));
        clientAnchor.setDx1((short)Units.pointsToMaster((double)(anchor.width + anchor.x)));
        clientAnchor.setRow1((short)Units.pointsToMaster((double)(anchor.height + anchor.y)));
        EscherSpgrRecord spgr = (EscherSpgrRecord)this.getEscherChild(-4087);
        spgr.setRectX1(Units.pointsToMaster((double)anchor.x));
        spgr.setRectY1(Units.pointsToMaster((double)anchor.y));
        spgr.setRectX2(Units.pointsToMaster((double)(anchor.x + anchor.width)));
        spgr.setRectY2(Units.pointsToMaster((double)(anchor.y + anchor.height)));
    }

    public void setInteriorAnchor(Rectangle anchor) {
        EscherSpgrRecord spgr = (EscherSpgrRecord)this.getEscherChild(-4087);
        int x1 = Units.pointsToMaster((double)anchor.getX());
        int y1 = Units.pointsToMaster((double)anchor.getY());
        int x2 = Units.pointsToMaster((double)(anchor.getX() + anchor.getWidth()));
        int y2 = Units.pointsToMaster((double)(anchor.getY() + anchor.getHeight()));
        spgr.setRectX1(x1);
        spgr.setRectY1(y1);
        spgr.setRectX2(x2);
        spgr.setRectY2(y2);
    }

    public Rectangle getInteriorAnchor() {
        EscherSpgrRecord rec = (EscherSpgrRecord)this.getEscherChild(-4087);
        int x1 = (int)Units.masterToPoints((int)rec.getRectX1());
        int y1 = (int)Units.masterToPoints((int)rec.getRectY1());
        int x2 = (int)Units.masterToPoints((int)rec.getRectX2());
        int y2 = (int)Units.masterToPoints((int)rec.getRectY2());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spgr = new EscherContainerRecord();
        spgr.setRecordId((short)-4093);
        spgr.setOptions((short)15);
        EscherContainerRecord spcont = new EscherContainerRecord();
        spcont.setRecordId((short)-4092);
        spcont.setOptions((short)15);
        EscherSpgrRecord spg = new EscherSpgrRecord();
        spg.setOptions((short)1);
        spcont.addChildRecord((EscherRecord)spg);
        EscherSpRecord sp = new EscherSpRecord();
        short type = (short)((ShapeType.NOT_PRIMITIVE.nativeId << 4) + 2);
        sp.setOptions(type);
        sp.setFlags(513);
        spcont.addChildRecord((EscherRecord)sp);
        EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
        spcont.addChildRecord((EscherRecord)anchor);
        spgr.addChildRecord((EscherRecord)spcont);
        return spgr;
    }

    public void addShape(HSLFShape shape) {
        this._escherContainer.addChildRecord((EscherRecord)shape.getSpContainer());
        HSLFSheet sheet = this.getSheet();
        shape.setSheet(sheet);
        shape.setShapeId(sheet.allocateShapeId());
        shape.afterInsert(sheet);
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchor();
        int dx = x - anchor.x;
        int dy = y - anchor.y;
        anchor.translate(dx, dy);
        this.setAnchor(anchor);
        for (HSLFShape shape : this.getShapes()) {
            Rectangle chanchor = shape.getAnchor();
            chanchor.translate(dx, dy);
            shape.setAnchor(chanchor);
        }
    }

    @Override
    public Rectangle getAnchor() {
        int y2;
        int x2;
        int y1;
        int x1;
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)this.getEscherChild(-4080);
        if (clientAnchor == null) {
            this.logger.log(3, new Object[]{"EscherClientAnchorRecord was not found for shape group. Searching for EscherChildAnchorRecord."});
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)this.getEscherChild(-4081);
            x1 = rec.getDx1();
            y1 = rec.getDy1();
            x2 = rec.getDx2();
            y2 = rec.getDy2();
        } else {
            x1 = clientAnchor.getCol1();
            y1 = clientAnchor.getFlag();
            x2 = clientAnchor.getDx1();
            y2 = clientAnchor.getRow1();
        }
        Rectangle anchor = new Rectangle((int)(x1 == -1 ? -1.0 : Units.masterToPoints((int)x1)), (int)(y1 == -1 ? -1.0 : Units.masterToPoints((int)y1)), (int)(x2 == -1 ? -1.0 : Units.masterToPoints((int)(x2 - x1))), (int)(y2 == -1 ? -1.0 : Units.masterToPoints((int)(y2 - y1))));
        return anchor;
    }

    @Override
    public ShapeType getShapeType() {
        EscherSpRecord spRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int nativeId = spRecord.getOptions() >> 4;
        return ShapeType.forId((int)nativeId, (boolean)false);
    }

    @Override
    public HSLFHyperlink getHyperlink() {
        return null;
    }

    @Override
    public <T extends EscherRecord> T getEscherChild(int recordId) {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        return (T)groupInfoContainer.getChildById((short)recordId);
    }

    public Iterator<HSLFShape> iterator() {
        return this.getShapes().iterator();
    }

    public boolean removeShape(HSLFShape shape) {
        throw new UnsupportedOperationException();
    }

    public List<HSLFShape> getShapes() {
        Iterator iter = this._escherContainer.getChildIterator();
        if (iter.hasNext()) {
            iter.next();
        }
        ArrayList<HSLFShape> shapeList = new ArrayList<HSLFShape>();
        while (iter.hasNext()) {
            EscherRecord r = (EscherRecord)iter.next();
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord container = (EscherContainerRecord)r;
                HSLFShape shape = HSLFShapeFactory.createShape(container, this);
                shape.setSheet(this.getSheet());
                shapeList.add(shape);
                continue;
            }
            this.logger.log(7, new Object[]{"Shape contained non container escher record, was " + r.getClass().getName()});
        }
        return shapeList;
    }

    @Override
    public HSLFTextBox createTextBox() {
        HSLFTextBox s = new HSLFTextBox(this);
        s.setHorizontalCentered(true);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    @Override
    public HSLFAutoShape createAutoShape() {
        HSLFAutoShape s = new HSLFAutoShape(ShapeType.RECT, (ShapeContainer<HSLFShape, HSLFTextParagraph>)this);
        s.setHorizontalCentered(true);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    @Override
    public HSLFFreeformShape createFreeform() {
        HSLFFreeformShape s = new HSLFFreeformShape(this);
        s.setHorizontalCentered(true);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    @Override
    public HSLFConnectorShape createConnector() {
        HSLFConnectorShape s = new HSLFConnectorShape(this);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    @Override
    public HSLFGroupShape createGroup() {
        HSLFGroupShape s = new HSLFGroupShape(this);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    @Override
    public HSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof HSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type HSLFPictureData");
        }
        HSLFPictureShape s = new HSLFPictureShape((HSLFPictureData)pictureData, (ShapeContainer<HSLFShape, HSLFTextParagraph>)this);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }

    public HSLFTable createTable(int numRows, int numCols) {
        if (numRows < 1 || numCols < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        HSLFTable s = new HSLFTable(numRows, numCols, this);
        s.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(s);
        return s;
    }
}

