/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.base.evaluators.AfterEvaluatorDefinition;
import org.drools.base.evaluators.BeforeEvaluatorDefinition;
import org.drools.base.evaluators.CoincidesEvaluatorDefinition;
import org.drools.base.evaluators.DuringEvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.FinishedByEvaluatorDefinition;
import org.drools.base.evaluators.FinishesEvaluatorDefinition;
import org.drools.base.evaluators.IncludesEvaluatorDefinition;
import org.drools.base.evaluators.IsAEvaluatorDefinition;
import org.drools.base.evaluators.MeetsEvaluatorDefinition;
import org.drools.base.evaluators.MetByEvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.OverlappedByEvaluatorDefinition;
import org.drools.base.evaluators.OverlapsEvaluatorDefinition;
import org.drools.base.evaluators.StartedByEvaluatorDefinition;
import org.drools.base.evaluators.StartsEvaluatorDefinition;
import org.drools.base.evaluators.StrEvaluatorDefinition;
import org.drools.common.DroolsObjectInput;
import org.drools.spi.Evaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorRegistry
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<String, EvaluatorDefinition> evaluators = new HashMap<String, EvaluatorDefinition>();
    private ClassLoader classloader;

    public EvaluatorRegistry() {
        this(null);
    }

    public EvaluatorRegistry(ClassLoader classloader) {
        this.classloader = classloader != null ? classloader : EvaluatorRegistry.getDefaultClassLoader();
        this.addEvaluatorDefinition(new BeforeEvaluatorDefinition());
        this.addEvaluatorDefinition(new AfterEvaluatorDefinition());
        this.addEvaluatorDefinition(new MeetsEvaluatorDefinition());
        this.addEvaluatorDefinition(new MetByEvaluatorDefinition());
        this.addEvaluatorDefinition(new OverlapsEvaluatorDefinition());
        this.addEvaluatorDefinition(new OverlappedByEvaluatorDefinition());
        this.addEvaluatorDefinition(new IncludesEvaluatorDefinition());
        this.addEvaluatorDefinition(new DuringEvaluatorDefinition());
        this.addEvaluatorDefinition(new FinishesEvaluatorDefinition());
        this.addEvaluatorDefinition(new FinishedByEvaluatorDefinition());
        this.addEvaluatorDefinition(new StartsEvaluatorDefinition());
        this.addEvaluatorDefinition(new StartedByEvaluatorDefinition());
        this.addEvaluatorDefinition(new CoincidesEvaluatorDefinition());
        this.addEvaluatorDefinition(new StrEvaluatorDefinition());
        this.addEvaluatorDefinition(new IsAEvaluatorDefinition());
    }

    public Set<String> keySet() {
        return this.evaluators.keySet();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (Map)in.readObject();
        this.classloader = in instanceof DroolsObjectInput ? ((DroolsObjectInput)in).getClassLoader() : EvaluatorRegistry.getDefaultClassLoader();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    private static ClassLoader getDefaultClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return EvaluatorRegistry.class.getClassLoader();
    }

    public void addEvaluatorDefinition(String className) {
        try {
            Class<?> defClass = this.classloader.loadClass(className);
            EvaluatorDefinition def = (EvaluatorDefinition)defClass.newInstance();
            this.addEvaluatorDefinition(def);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Class not found for evaluator definition: " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error instantiating class for evaluator definition: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Illegal access instantiating class for evaluator definition: " + className, e);
        }
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        for (String id : def.getEvaluatorIds()) {
            this.evaluators.put(id, def);
        }
    }

    public EvaluatorDefinition getEvaluatorDefinition(String evaluatorId) {
        return this.evaluators.get(evaluatorId);
    }

    public EvaluatorDefinition getEvaluatorDefinition(Operator operator) {
        return this.evaluators.get(operator.getOperatorString());
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluatorDefinition(operatorId).getEvaluator(type, operatorId, isNegated, parameterText);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluatorDefinition(operator).getEvaluator(type, operator, parameterText);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluatorDefinition(operator).getEvaluator(type, operator);
    }
}

