/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.drools.core.util.StringUtils;
import org.drools.kproject.File;
import org.drools.kproject.FileSystem;
import org.drools.kproject.Folder;
import org.drools.kproject.KBase;
import org.drools.kproject.KProject;
import org.drools.kproject.KProjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReader {
    private FileSystem fs;
    private KProject kproject;

    public ProjectReader(FileSystem fs) {
        this.fs = fs;
        this.kproject = new KProjectImpl();
    }

    public KProject getKproject() {
        return this.kproject;
    }

    public void read() {
        this.readKBasePaths();
    }

    public void readKBasePaths() {
        Properties props = null;
        try {
            props = ProjectReader.loadProperties(this.fs.getProjectFolder().getFile("kbasePaths.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.kproject.setKProjectPath(props.getProperty("kproject").trim());
    }

    public void readKBase(Map.Entry<String, String> entry) {
        Folder folder = this.fs.getFolder(entry.getValue());
        String kbaseQName = entry.getKey();
        File file = folder.getFile(kbaseQName + ".properties");
        Properties props = null;
        try {
            props = ProjectReader.loadProperties(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String namespace = props.getProperty("namespace");
        String name = props.getProperty("name");
        String filesStr = props.getProperty("files");
        ArrayList<String> files = new ArrayList<String>();
        for (String str : filesStr.split(",")) {
            if (StringUtils.isEmpty(str)) continue;
            files.add(str.trim());
        }
    }

    public void readKSession(String ksessionQName, Map<String, String> map, KBase kbase, KProject kproject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        if (!file.exists()) return props;
        InputStream is = null;
        try {
            is = file.getContents();
            props.load(is);
            Object var4_3 = null;
            if (is == null) return props;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return props;
    }

    private void mapStartsWith(Map<String, String> map, Properties properties, String startsWith) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || map.containsKey(key)) continue;
            map.put(key.substring(startsWith.length() + 1), properties.getProperty(key));
        }
    }
}

