/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.asm.MethodComparator;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.builder.dialect.asm.InvokerDataProvider;
import org.drools.rule.builder.dialect.asm.InvokerStub;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.Tuple;
import org.drools.util.CompositeClassLoader;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratorHelper {
    public static final Long INVOKER_SERIAL_UID = new Long(510L);

    public static List<DeclarationMatcher> matchDeclarationsToTuple(Declaration[] declarations) {
        ArrayList<DeclarationMatcher> matchers = new ArrayList<DeclarationMatcher>();
        for (int i = 0; i < declarations.length; ++i) {
            matchers.add(new DeclarationMatcher(i, declarations[i]));
        }
        Collections.sort(matchers);
        return matchers;
    }

    static CompositeClassLoader getCompositeClassLoader(Object obj) {
        ClassLoader classLoader = obj.getClass().getClassLoader();
        while (true) {
            if (classLoader instanceof CompositeClassLoader) {
                return (CompositeClassLoader)classLoader;
            }
            ClassLoader parentLoader = classLoader.getParent();
            if (parentLoader == null || parentLoader == classLoader) break;
            classLoader = parentLoader;
        }
        return null;
    }

    static CompositeClassLoader getCompositeClassLoader(Object obj, WorkingMemory workingMemory) {
        CompositeClassLoader classLoader = GeneratorHelper.getCompositeClassLoader(obj);
        if (classLoader == null) {
            classLoader = ((AbstractRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
        }
        return classLoader;
    }

    static ClassGenerator createInvokerClassGenerator(InvokerStub stub, WorkingMemory workingMemory) {
        String className = stub.getPackageName() + "." + stub.getGeneratedInvokerClassName();
        CompositeClassLoader classLoader = GeneratorHelper.getCompositeClassLoader(stub, workingMemory);
        return GeneratorHelper.createInvokerClassGenerator(className, stub, classLoader, GeneratorHelper.getTypeResolver(stub, workingMemory, classLoader));
    }

    static ClassGenerator createInvokerClassGenerator(String className, final InvokerDataProvider data, CompositeClassLoader classLoader, TypeResolver typeResolver) {
        ClassGenerator generator = new ClassGenerator(className, classLoader, typeResolver).addStaticField(18, "serialVersionUID", Long.TYPE, INVOKER_SERIAL_UID).addDefaultConstructor();
        generator.addMethod(1, "hashCode", generator.methodDescr(Integer.TYPE, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.hashCode());
                mv.visitInsn(172);
            }
        }).addMethod(1, "getMethodBytecode", generator.methodDescr(List.class, new Class[0]), new GetMethodBytecodeMethod(data)).addMethod(1, "equals", generator.methodDescr(Boolean.TYPE, Object.class), new EqualsMethod());
        return generator;
    }

    static TypeResolver getTypeResolver(InvokerStub stub, WorkingMemory workingMemory, CompositeClassLoader classLoader) {
        TypeResolver typeResolver;
        Package pkg = workingMemory.getRuleBase().getPackage(stub.getPackageName());
        TypeResolver typeResolver2 = typeResolver = pkg == null ? null : pkg.getTypeResolver();
        if (typeResolver == null) {
            HashSet<String> imports = new HashSet<String>();
            for (String imp : stub.getPackageImports()) {
                imports.add(imp);
            }
            typeResolver = new ClassTypeResolver(imports, classLoader, stub.getPackageName());
        }
        return typeResolver;
    }

    public static Class<?> asPrimitive(String className) {
        if (className.equals(Integer.class.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Boolean.class.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Character.class.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Byte.class.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.class.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Float.class.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Long.class.getName())) {
            return Long.TYPE;
        }
        if (className.equals(Double.class.getName())) {
            return Double.TYPE;
        }
        return Object.class;
    }

    public static abstract class EvaluateMethod
    extends DeclarationAccessorMethod {
        protected int objAstorePos;

        protected int[] parseDeclarations(Declaration[] declarations, int declarReg, int tupleReg, int wmReg, boolean readLocalsFromTuple) {
            int[] declarationsParamsPos = new int[declarations.length];
            for (int i = 0; i < declarations.length; ++i) {
                declarationsParamsPos[i] = this.objAstorePos;
                this.mv.visitVarInsn(25, declarReg);
                this.push(i);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(25, wmReg);
                this.cast(InternalWorkingMemory.class);
                if (readLocalsFromTuple) {
                    this.mv.visitVarInsn(25, tupleReg);
                    this.mv.visitVarInsn(25, declarReg);
                    this.push(i);
                    this.mv.visitInsn(50);
                    this.invokeInterface(Tuple.class, "get", InternalFactHandle.class, Declaration.class);
                    this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                } else {
                    this.mv.visitVarInsn(25, 1);
                }
                String readMethod = declarations[i].getNativeReadMethodName();
                boolean isObject = readMethod.equals("getValue");
                String declarationType = declarations[i].getTypeName();
                String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declarationType);
                this.mv.visitMethodInsn(182, "org/drools/rule/Declaration", readMethod, "(Lorg/drools/common/InternalWorkingMemory;Ljava/lang/Object;)" + returnedType);
                if (isObject) {
                    this.mv.visitTypeInsn(192, this.internalName(declarationType));
                }
                this.objAstorePos += this.store(this.objAstorePos, declarationType);
            }
            return declarationsParamsPos;
        }

        protected void parseGlobals(String[] globals, String[] globalTypes, int wmReg, StringBuilder methodDescr) {
            for (int i = 0; i < globals.length; ++i) {
                this.mv.visitVarInsn(25, wmReg);
                this.push(globals[i]);
                this.invokeInterface(WorkingMemory.class, "getGlobal", Object.class, String.class);
                this.mv.visitTypeInsn(192, this.internalName(globalTypes[i]));
                methodDescr.append(this.typeDescr(globalTypes[i]));
            }
        }

        protected void storeObjectFromDeclaration(Declaration declaration, String declarationType) {
            this.objAstorePos += this.storeObjectFromDeclaration(declaration, declarationType, this.objAstorePos);
        }
    }

    public static abstract class DeclarationAccessorMethod
    extends ClassGenerator.MethodBody {
        protected int storeObjectFromDeclaration(Declaration declaration, int registry) {
            return this.storeObjectFromDeclaration(declaration, declaration.getTypeName(), registry);
        }

        protected int storeObjectFromDeclaration(Declaration declaration, String declarationType, int registry) {
            InternalReadAccessor extractor;
            String readMethod = declaration.getNativeReadMethodName();
            boolean isObject = readMethod.equals("getValue");
            String expectedTypeDescr = this.typeDescr(declarationType);
            boolean needsPrimitive = !expectedTypeDescr.startsWith("L") && !expectedTypeDescr.startsWith("[");
            String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declaration.getTypeName());
            this.mv.visitMethodInsn(182, "org/drools/rule/Declaration", readMethod, "(Lorg/drools/common/InternalWorkingMemory;Ljava/lang/Object;)" + returnedType);
            if (isObject && (extractor = declaration.getExtractor()) != null) {
                this.cast(extractor.getExtractToClass());
            }
            if (needsPrimitive && isObject) {
                this.castToPrimitive(this.forPrimitiveName(declarationType));
            } else if (!needsPrimitive && !isObject) {
                this.castFromPrimitive(this.forPrimitiveName(declaration.getExtractor().getExtractToClassName()));
            } else if (needsPrimitive && !isObject && !returnedType.equals(declarationType)) {
                this.castPrimitiveToPrimitive(declaration.getExtractor().getExtractToClass(), this.forPrimitiveName(declarationType));
            }
            return this.store(registry, declarationType);
        }

        protected LeftTuple traverseTuplesUntilDeclaration(LeftTuple currentLeftTuple, int declarOffset, int tupleReg) {
            while (currentLeftTuple.getIndex() > declarOffset) {
                this.mv.visitVarInsn(25, tupleReg);
                this.invokeInterface(LeftTuple.class, "getParent", LeftTuple.class, new Class[0]);
                this.mv.visitVarInsn(58, tupleReg);
                currentLeftTuple = currentLeftTuple.getParent();
            }
            return currentLeftTuple;
        }

        protected void traverseTuplesUntilDeclarationWithOr(int declarIndex, int declarReg, int tupleReg, int declarOffsetReg) {
            this.mv.visitVarInsn(25, declarReg);
            this.push(declarIndex);
            this.mv.visitInsn(50);
            this.invokeVirtual(Declaration.class, "getPattern", Pattern.class, new Class[0]);
            this.invokeVirtual(Pattern.class, "getOffset", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(54, declarOffsetReg);
            Label whileStart = new Label();
            Label whileExit = new Label();
            this.mv.visitLabel(whileStart);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(LeftTuple.class, "getIndex", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(21, declarOffsetReg);
            this.mv.visitJumpInsn(164, whileExit);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(LeftTuple.class, "getParent", LeftTuple.class, new Class[0]);
            this.mv.visitVarInsn(58, tupleReg);
            this.mv.visitJumpInsn(167, whileStart);
            this.mv.visitLabel(whileExit);
        }
    }

    public static class EqualsMethod
    extends ClassGenerator.MethodBody {
        public void body(MethodVisitor mv) {
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 1);
            this.instanceOf(CompiledInvoker.class);
            mv.visitJumpInsn(154, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            this.invokeThis("getMethodBytecode", List.class, new Class[0]);
            mv.visitVarInsn(25, 1);
            this.cast(CompiledInvoker.class);
            this.invokeInterface(CompiledInvoker.class, "getMethodBytecode", List.class, new Class[0]);
            this.invokeStatic(MethodComparator.class, "compareBytecode", Boolean.TYPE, List.class, List.class);
            mv.visitInsn(172);
        }
    }

    public static class GetMethodBytecodeMethod
    extends ClassGenerator.MethodBody {
        private InvokerDataProvider data;

        public GetMethodBytecodeMethod(InvokerDataProvider data) {
            this.data = data;
        }

        public void body(MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            this.invokeVirtual(Object.class, "getClass", Class.class, new Class[0]);
            this.push(this.data.getRuleClassName());
            this.push(this.data.getPackageName());
            this.push(this.data.getMethodName());
            this.push(this.data.getInternalRuleClassName() + ".class");
            this.invokeStatic(Rule.class, "getMethodBytecode", List.class, Class.class, String.class, String.class, String.class, String.class);
            mv.visitInsn(176);
        }
    }

    public static class DeclarationMatcher
    implements Comparable {
        private final Declaration declaration;
        private final int originalIndex;
        private final int rootDistance;

        public DeclarationMatcher(int originalIndex, Declaration declaration) {
            this.declaration = declaration;
            this.originalIndex = originalIndex;
            this.rootDistance = declaration.getPattern().getOffset();
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public int getRootDistance() {
            return this.rootDistance;
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public int compareTo(Object obj) {
            return ((DeclarationMatcher)obj).rootDistance - this.rootDistance;
        }
    }
}

