/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.packed.PackedInts;

public class MergeState {
    public SegmentInfo segmentInfo;
    public FieldInfos fieldInfos;
    public List<AtomicReader> readers;
    public DocMap[] docMaps;
    public int[] docBase;
    public CheckAbort checkAbort;
    public InfoStream infoStream;
    public FieldInfo fieldInfo;
    public SegmentReader[] matchingSegmentReaders;
    public int matchedCount;

    MergeState() {
    }

    public static class CheckAbort {
        private double workCount;
        private final MergePolicy.OneMerge merge;
        private final Directory dir;
        static final CheckAbort NONE = new CheckAbort(null, null){

            @Override
            public void work(double units) {
            }
        };

        public CheckAbort(MergePolicy.OneMerge merge, Directory dir) {
            this.merge = merge;
            this.dir = dir;
        }

        public void work(double units) throws MergePolicy.MergeAbortedException {
            this.workCount += units;
            if (this.workCount >= 10000.0) {
                this.merge.checkAborted(this.dir);
                this.workCount = 0.0;
            }
        }
    }

    private static class DelCountDocMap
    extends DocMap {
        private final PackedInts.Mutable numDeletesSoFar;

        private DelCountDocMap(Bits liveDocs, PackedInts.Mutable numDeletesSoFar) {
            super(liveDocs);
            this.numDeletesSoFar = numDeletesSoFar;
        }

        @Override
        public int remap(int docId) {
            return docId - (int)this.numDeletesSoFar.get(docId);
        }

        @Override
        public int maxDoc() {
            return this.numDeletesSoFar.size();
        }

        @Override
        public int numDeletedDocs() {
            int maxDoc = this.maxDoc();
            return (int)this.numDeletesSoFar.get(maxDoc - 1);
        }
    }

    private static class DirectDocMap
    extends DocMap {
        private final PackedInts.Mutable docIds;
        private final int numDeletedDocs;

        private DirectDocMap(Bits liveDocs, PackedInts.Mutable docIds, int numDeletedDocs) {
            super(liveDocs);
            this.docIds = docIds;
            this.numDeletedDocs = numDeletedDocs;
        }

        @Override
        public int remap(int docId) {
            return (int)this.docIds.get(docId);
        }

        @Override
        public int maxDoc() {
            return this.docIds.size();
        }

        @Override
        public int numDeletedDocs() {
            return this.numDeletedDocs;
        }
    }

    private static class NoDelDocMap
    extends DocMap {
        private final int maxDoc;

        private NoDelDocMap(int maxDoc) {
            super(null);
            this.maxDoc = maxDoc;
        }

        @Override
        public int remap(int docId) {
            return docId;
        }

        @Override
        public int maxDoc() {
            return this.maxDoc;
        }

        @Override
        public int numDeletedDocs() {
            return 0;
        }
    }

    public static abstract class DocMap {
        private final Bits liveDocs;

        protected DocMap(Bits liveDocs) {
            this.liveDocs = liveDocs;
        }

        public static DocMap build(AtomicReader reader) {
            int maxDoc = reader.maxDoc();
            int numDeletes = reader.numDeletedDocs();
            int numDocs = maxDoc - numDeletes;
            assert (reader.getLiveDocs() != null || numDeletes == 0);
            if (numDeletes == 0) {
                return new NoDelDocMap(maxDoc);
            }
            if (numDeletes < numDocs) {
                return DocMap.buildDelCountDocmap(maxDoc, numDeletes, reader.getLiveDocs(), 0.0f);
            }
            return DocMap.buildDirectDocMap(maxDoc, numDocs, reader.getLiveDocs(), 0.0f);
        }

        static DocMap buildDelCountDocmap(int maxDoc, int numDeletes, Bits liveDocs, float acceptableOverheadRatio) {
            PackedInts.Mutable numDeletesSoFar = PackedInts.getMutable(maxDoc, PackedInts.bitsRequired(numDeletes), acceptableOverheadRatio);
            int del = 0;
            for (int i = 0; i < maxDoc; ++i) {
                if (!liveDocs.get(i)) {
                    ++del;
                }
                numDeletesSoFar.set(i, del);
            }
            assert (del == numDeletes) : "del=" + del + ", numdeletes=" + numDeletes;
            return new DelCountDocMap(liveDocs, numDeletesSoFar);
        }

        static DocMap buildDirectDocMap(int maxDoc, int numDocs, Bits liveDocs, float acceptableOverheadRatio) {
            PackedInts.Mutable docIds = PackedInts.getMutable(maxDoc, PackedInts.bitsRequired(Math.max(0, numDocs - 1)), acceptableOverheadRatio);
            int del = 0;
            for (int i = 0; i < maxDoc; ++i) {
                if (liveDocs.get(i)) {
                    docIds.set(i, i - del);
                    continue;
                }
                ++del;
            }
            assert (numDocs + del == maxDoc) : "maxDoc=" + maxDoc + ", del=" + del + ", numDocs=" + numDocs;
            return new DirectDocMap(liveDocs, docIds, del);
        }

        public int get(int docId) {
            if (this.liveDocs == null || this.liveDocs.get(docId)) {
                return this.remap(docId);
            }
            return -1;
        }

        public abstract int remap(int var1);

        public abstract int maxDoc();

        public final int numDocs() {
            return this.maxDoc() - this.numDeletedDocs();
        }

        public abstract int numDeletedDocs();

        public boolean hasDeletions() {
            return this.numDeletedDocs() > 0;
        }
    }
}

