/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Map;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class ResourceValidationStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger(ResourceValidationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache");
        }
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        if (resourceMap == null) {
            throw new StageException("Resources must be computed prior to validation!");
        }
        Map<String, IdealState> idealStateMap = cache.getIdealStates();
        Map<String, Map<String, String>> idealStateRuleMap = cache.getIdealStateRules();
        for (String resourceName : idealStateMap.keySet()) {
            String stateModelDefRef;
            StateModelDefinition stateModelDef;
            IdealState idealState = idealStateMap.get(resourceName);
            if (!idealStateRuleMap.isEmpty()) {
                boolean hasMatchingRule = false;
                for (String ruleName : idealStateRuleMap.keySet()) {
                    Map<String, String> rule = idealStateRuleMap.get(ruleName);
                    boolean matches = this.idealStateMatchesRule(idealState, rule);
                    boolean bl = hasMatchingRule = hasMatchingRule || matches;
                    if (!matches) continue;
                    break;
                }
                if (!hasMatchingRule) {
                    LOG.warn((Object)("Resource " + resourceName + " does not have a valid ideal state!"));
                    resourceMap.remove(resourceName);
                }
            }
            if ((stateModelDef = cache.getStateModelDef(stateModelDefRef = idealState.getStateModelDefRef())) != null) continue;
            LOG.warn((Object)("Resource " + resourceName + " uses state model " + stateModelDefRef + ", but it is not on the cluster!"));
            resourceMap.remove(resourceName);
        }
    }

    private boolean idealStateMatchesRule(IdealState idealState, Map<String, String> rule) {
        Map<String, String> simpleFields = idealState.getRecord().getSimpleFields();
        for (String key : rule.keySet()) {
            String value = rule.get(key);
            if (simpleFields.containsKey(key) && value.equals(simpleFields.get(key))) continue;
            return false;
        }
        return true;
    }
}

